#!WHICH_PERL
# deceptive defense - wear down the attackers and all their port scanners and so forth
# Copyright (c), 1998, Fred Cohen - All Right Reserved
# RFC 821 SMTP implementation
# Copyright (c), 1986 by Management Analytics - All Rights Reserved

# NOTICE: By taking this copy, you agree that all updates and modifications
# will be reported back to us, that you will only use it to defend systems and
# not to figure out how to attack them, that we retain all right to the
# software provided to you and any revisions, enhancements, or derivitive
# works that may result from it, that you will retain all copyright notices on
# all copies you distribute elsewhere, and that anyone you give it to will
# also agree to these terms. 

$PERLLIB="WHICH_PERL_LIB";
# require 'syscall.ph';
$state="0";		# initial state
$timeout=TIME_OUT;		# seconds to say something else or I go away
$maxloops=MAX_LOOP;		# maximum number of input lines before we exit anyway
$progname="smtp.pl";

# fix LOGIT to use DTK logging
sub LOGIT {$IN="$_[0]";LOG();}

chdir "WORKING_DIR" || die "configuration error - please contact the site administrator\n";
# go to the right directory for this stuf
require 'logging.pl';
require 'respond.pl';
require 'orders.pl';

# output right away
$|=1;
alarm($timeout);
$ipadd=@ARGV[0];$port=@ARGV[1];$uid=@ARGV[2];$daemon=@ARGV[3];$user=@ARGV[4];
$realtime=0;$listenPID=$$;$con=1; $OurPort=$port;	# for logging
LOGON();

sub FIXLINE {$l=$_[0];$l=~tr/\n\r//d;return $l;}

sub ONEWORD {$l=$_[0];$l=~tr/A-Za-z0-9_!#\@!~\$%^&*()[]{}_\-+=|:;\/?><,\./_/c;return $l;}

select(STDIN); $|=1;select(STDOUT); $|=1;
$Commands=0;$MaxCommands=20;
$NAME="Sendmail";
alarm($timeout);
@STATES=("init", "helo", "data", "quit", "from", "to");
@COMMANDS=("helo", "mail", "rcpt", "data", "rset", "noop", "quit");
@content=();
$maxlines = 200;
$maxsize = 5000;
$maxfile = 5000;
$timeout=20;
($MACHINE,$void)=split(/\n/,`/bin/hostname`,2);
$MACHINE="NEW_HOST_NAME";
@PFILE=split(/\n/,<WORKING_DIR/@fake.passwd`);
foreach $LINE (@PFILE)
	{($user, $pwd, $uid, $gid, $name, $home, $shell)=split(/:/, $LINE);
	$USERS{"$user"}="$maildir/$user";$USERS{"$user\@$MACHINE"}="$maildir/$user";
	$OWNERS{"$maildir/$user"}="$uid";$GROUPS{"$maildir/$user"}="$gid";}
$remhost=@ARGV[0];$remuser=@ARGV[1];
$remhost=~tr/A-Z/a-z/;$remuser=~tr/A-Z/a-z/;
($remip,$remh)=split(/-/,$remhost,2);
alarm(20);$state="init";
print "220 $MACHINE $NAME V8.2 - ready to recieve ... from $remhost $remuser\n";
while (<STDIN>)
   {	alarm($timeout);tr/A-Z/a-z/;
	$Commands=$Commands+1;
	if ($Commands > $MaxCommands)
		{print "500 Too many commands\n";LOGIT("500 Too Many Commands");exit;}
	$line=FIXLINE($_);
	$IN=$line;LOGON();
	($command, $args) = split(/\s+/,$line,2);
	if ($command eq "rset") {$state="init";print "250 OK\n";}
	elsif ($command eq "noop") {print "250 OK\n";}
	elsif ($command eq "help") {print "250 OK - This mailer is beyond help\n";}
	elsif ($command eq "quit") {print "221 $MACHINE says we gone.\n";$state="quit";exit;}
	elsif ($command eq "ehlo") {print "500 Unrecognized new protocol command ehlo\n";}
	elsif ($command eq "helo")
		{$revremhost=reverse($remh);$revargs=reverse($args);
		($name1, $void) = split(/\./,$remh,2);
		($dom1, $net1, $void) = split(/\./,$revremhost,3);
		($dom2, $net2, $void) = split(/\./,$revargs,3);
		($dom3, $void) = split(/\./,$remh,2);
		if ($state ne "init") {print "503 Bad sequence of commands - start again with rset.\n";LOGIT("503 Bad sequence in helo? - $line");}
		elsif (($remip ne $args) && (($dom3 ne $args) && (($dom1 ne $dom2) || ($net1 ne $net2)) && ($name1 ne $args)))
			{print "501 Host name ($args) inconsitent with DNS ($remhost).\n";LOGIT("501 Host name inconsistent with DNS - $line");}
		else {print "250 OK - Hello $remhost ($args)\n"; $state="helo";
			$remhost2=$args;}
		}
	elsif ($command eq "mail")
		{if ($state ne "helo") {print "503 Bad sequence of commands - start with helo\n";LOGIT("503 mail without helo - $line");}
		else	{($from, $sender) = split(/:/,$args,2);
			if ($from ne "from") {print "501 Mail from where?\n";LOGIT("503 No from: - $line");}
			elsif (scalar($sender) > 128) {print "500 Line too long.\n";LOGIT("500 Line too long - $line");}
			elsif ($sender eq "") {print "501 No sender specified.\n";LOGIT("501 no sender specified - $line");}
			elsif (substr($sender,0,1) ne "<") {print "501 Syntax error - missing <\n";LOGIT("501 No < - $line");}
			elsif (substr($sender,-1,1) ne ">") {print "501 Syntax error - no final >\n";LOGIT("501 no final > - $line");}
			else {$state="from";print "250 OK\n";
				if ($sender eq "<>") {$sender="<$remuser\@$remhost>";}
				$sender=ONEWORD($sender);
				chop $sender;$sender=substr($sender, 1);}
			}
		}
	elsif ($command eq "rcpt")
		{if (($state ne "from") && ($state ne "to"))
				{print "503 Bad sequence of commands - say mail first\n";LOGIT("503 rcpt without mail - $line");}
		else	{($rcpt, $to)= split(/:/,$args,2);
			if ($rcpt ne "to") {print "501 Syntax error - rcpt to who?\n";LOGIT("501 didn't say to: - $line");}
			elsif (substr($to,0,1) ne "<") {print "501 Syntax error - missing <\n";LOGIT("501 No < - $line");}
			elsif (substr($to,-1,1) ne ">") {print "501 Syntax error - no final >\n";LOGIT("501 no final > - $line");}
			else {chop $to;$to=substr($to,1);
				$ouruser=$USERS{"$to"};$home=$HOMES{"$ouruser"};
			if ($USERS{"$to"} eq "") {print "550 A:No such user as $to here\n";LOGIT("550 No valid user specified - $sender\@$remhost - $line");}
			elsif (CHECKACCESS("$remh","$sender") == 1) {print "550 ($to) No such user here\n";
				LOGIT("530 Access Control - $sender\@$remhost to $to: $line");}
			elsif (CHECKACCESS("$remip","$sender") == 1) {print "550 ($to) No such user here\n";
				LOGIT("530 Access Control - $sender\@$remhost to $to: $line");}
			else {$state="to";print "250 OK\n";push(@tolist,$to);}
			}    }
		}
	elsif ($command eq "data")
		{if ($state ne "to") {print "503 Bad sequence of commands - need a rcpt somewhere.\n";LOGIT("503D - $line");}
		else {print "354 Start mail input.\n";
			$lines=0;$size=0;$linesout=0;$sizeout=0;
			while (($inline=(<STDIN>)) && ($inline ne ".\r")
				&& ($inline ne ".\n")&& ($inline ne ".\r\n"))
				{alarm($timeout);
				if (substr($inline,0,1) eq ".") {$inline=substr($inline,1);}
				if (substr($inline,0,5) eq "From ") {$inline=">$inline";}
				$lines=$lines+1; $size=$size+length($inline);
				if ($lines > $maxlines) {$linesout=1;}
				elsif ($size > $maxsize) {$sizeout=1;}
				else {push(@mess,FIXLINE($inline));}}
			if ($sizeout == 1) {LOGIT("Too many bytes in email");
				print "552 Email is too big\n";exit;}
			elsif ($linesout == 1) {LOGIT("Too many lines in email");
				print "552 Email has too many lines\n";exit;}
			    }	}	}
			print "250 OK\n";$state="init";
			}
		}
	else {print "502 Command $command not implemented.  Sorry.\n";$IN="502Q - Command not implemented: $line";LOGON();}
   }
