#!/usr/bin/perl -w 
$PERLLIB="/usr/lib/perl5";
# udpmsg - send a message to the udpquotd server 

my($sock, $server_host, $msg, $port, $ipaddr, $hishost, 
       $MAXLEN, $PORTNO, $TIMEOUT, 
); 

use Socket; 
use strict; 

$MAXLEN  = 1024; 
$PORTNO  = 5151; 
$TIMEOUT = 5; 

$server_host = shift; 
$msg         = "@ARGV"; 
$sock = Socket::INET->new(Proto     => 'udp', 
                                  PeerPort  => $PORTNO, 
                                  PeerAddr  => $server_host, 
                                ); 
$sock->send($msg) || die "send: $!"; 

eval { 
    $SIG{ALRM} = sub { die "alarm time out" }; 
    alarm $TIMEOUT; 
    $sock->recv($msg, $MAXLEN)  || die "recv: $!"; 
    alarm 0; 
    1;  # return value from eval on normalcy 
} || die "recv from $server_host timed out after $TIMEOUT seconds.\n"; 

($port, $ipaddr) = sockaddr_in($sock->peername); 
$hishost = gethostbyaddr($ipaddr, AF_INET); 
print "Server $hishost responded ``$msg''\n"; 
