#!WHICH_PERL
# deceptive defense - wear down the attackers and watch them as they do it
# Copyright (c), 1998, Fred Cohen - All Right Reserved

# NOTICE: By taking this copy, you agree that all updates and modifications
# will be reported back to us, that you will only use it to defend systems and
# not to figure out how to attack them, that we retain all right to the
# software provided to you and any revisions, enhancements, or derivitive
# works that may result from it, that you will retain all copyright notices on
# all copies you distribute elsewhere, and that anyone you give it to will
# also agree to these terms.

# Wrappers is used to modify DTK components of a hosts.allow file so as to scale up and
# down the defenses for a system, and thinking globally - a network or the world
#
# Formats for TCP wrappers lines to be controlled by DTK are as follows:
#
# For each place in the TCP wrappers file where DTK can act, there is a specification
# comment line that indicates which deception services can be controlled there. For
# example, to place a line allowing control over telnet services, my /etc/hosts.allow
# file starts with the following lines:
#	# DTK	START	23	in.telnetd
#	# DTK	END	23	in.telnetd
#
# As DTK determines that it wants to alter access to telnet deceptions (and actual services)
# it is permitted to add lines between these two lines sich as the following ones to grant
# telnet access to 1.2.3.4, deny telnet access to 1.2.3.5, twist all telnets from 1.2.4.*
# to a telnet deception, and deny all other telnet accesses.
#
#	in.telnetd:     1.2.3.4: allow
#	in.telnetd:     1.2.3.5: deny
#	in.telnetd:     1.2.4.:	twist /dtk/telnetd/telnetd -L /dtk/Telnet.pl
#	in.telnetd:	all:	deny
#
# Anything appearing between the START and END lines can be altered by DTK for the port and
# service specified, including denial of all other services to that port and ther permitting
# of all services to that port. It all depends on the sate table provided in the response list.
#
# Be advised that the placement of the START and END lines in your hosts.allow file make a big
# difference in the potential impact on operations caused by the wrappers control functions.

sub Rprint {local $line=$_[0];
		if ($debug == 1) {print "RPrinting $line\n";}
		if (0 == print $F $line) {byebye("PortScanClosed");}
		if ($debug == 1) {print "Rprint worked\n";}
		return;}
	# if print fails - closed filehandle or socket - from a finscan no doubt

# the response generated from the nn.response file
sub RESPOND {$F=$_[0];
	if ($debug == 1) {print "Responding to $con in S$state\n";}
	$content=0;@set=grep(/^$state	!/,@XREF);
	foreach $i (@set)
		{($state, $bang, $nextstate, $continue, $crlf, $stimulus, $response)=split(" ",$i,7);
		$_=$IN;if (?$stimulus?) {$content=1;last;}}
# match patterns - m!.....! OR /...../
	if ($content == 0)		# not a ! line, let's try for a pattern space
		{@set=grep(/^$state	M/,@XREF);
		foreach $i (@set)
			{($state, $stimulus, $nextstate, $continue, $crlf, $response)=split(" ",$i,6);
			($m, $n)=split(//, $stimulus, 2);$m="m$n";
			# if ($debug == 1) {Rprint("m$n matched against $IN\n");}
			$_=$IN;if (eval($m)) {$content=1;last;}}}
	if ($content == 0)		# not an m line, let's try for /
		{@set=grep(/^$state	\//,@XREF);
		foreach $i (@set)
			{($state, $stimulus, $nextstate, $continue, $crlf, $response)=split(" ",$i,6);
			$_=$IN;if (eval($stimulus)) {$content=1;last;}}}
# match first word
	if ($content == 0)		# no pattern matches, try straight text matches for first word
		{@pair=grep(/^$state	$what/,@XREF);$pair=@pair[0];
		if ($pair eq "") {@pair=grep(/^$state	ERROR/,@XREF);$pair=@pair[0];}
		($state, $stimulus, $nextstate, $continue, $crlf, $response)=split(" ",$pair,6);}
	chop($response);
	if ($debug == 1) {print "Response should be $response - crlf = $crlf\n";}
	if ($crlf eq "1") {Rprint ("$response\n\r");}
	elsif ($crlf eq "2")
		{if ($debug == 1) {print "Getting file $response\n";}
		open(File,"<$response");@CONTENT=<File>;close(File);$len=@CONTENT;
		if ($debug == 1) {print "Printing file $response\n";}
		foreach $i (@CONTENT){chop($i);$len=$len-1;
			if ($len == 0) {Rprint("$i");} else {Rprint ("$i\r\n");}}}
	elsif ($crlf eq "-echo") {system("stty -echo");Rprint ("$response");}
	elsif ($crlf eq "+echo") {system("stty echo");Rprint ("\r\n$response");}
	elsif ($crlf eq "exec") {exec($response);}
	elsif ($crlf eq "@")			# @ means run from new response file
		{open(File,"<WORKING_DIR/$response");@tmp=<File>;close(File);
		@XREF=grep('!^#',@tmp);@ORDERS=grep(/^!/,@XREF);DoOrders();	# get Xref and Orders
		$nextstate=0;}
	else    {Rprint("$response");}
	$state=$nextstate;
	if ($debug == 1) {print "Nextstate = $nextstate\n";}
	@set=grep(/^$state	NOTICE/,@XREF);
	foreach $i (@set)			# notification on next state entry
		{($state, $notify, $program, $parameters)=split(" ",$i,4);
		system("$program $port $state $parameters");
		$IN="$notify $program $port $state $parameters";LOGON();}
	}
return(TRUE);
