dnl $Id: acinclude.m4,v 1.4 1999/07/22 04:57:01 route Exp $
dnl
dnl     Libnet specific autoconf macros
dnl     Copyright (c) 1998, 1999 Mike D. Schiffman <mike@infonexus.com>
dnl                              route|daemon9 <route@infonexus.com>
dnl     All rights reserved.
dnl

dnl
dnl Checks to see if this linux kernel has a working PF_PACKET
dnl
dnl usage:
dnl
dnl     AC_LIBNET_CHECK_PF_PACKET
dnl
dnl results:
dnl
dnl     HAVE_PF_PACKET (DEFINED)
dnl

AC_DEFUN(AC_LIBNET_CHECK_PF_PACKET,
[
    AC_MSG_CHECKING(for PF_PACKET)
    AC_CACHE_VAL(ac_libnet_have_pf_packet,

        [case "$target_os" in

        linux)
                ac_libnet_have_pf_packet = no
                ;;
        *)

    cat > pf_packet-test.c << EOF
#include <net/if.h>
#if (__GLIBC__)
#include <netinet/if_ether.h>
#include <net/if_arp.h>
#else
#include <linux/if_arp.h>
#include <linux/if_ether.h>
#endif
#if (PF_PACKET)
#ifndef SOL_PACKET
#define SOL_PACKET 263
#endif  /* SOL_PACKET */
#include <linux/if_packet.h>
#endif
#include "./include/libnet.h"

int
main()
{
#if (PF_PACKET)
    int fd;
    struct sockaddr_ll sa;
    struct ifreq ifr;
    struct packet_mreq mr;
    char *device ="lo";

    fd = socket(PF_PACKET, SOCK_RAW, htons(ETH_P_ALL));
    if (fd == -1)
    {
        printf("choked");
        exit (EXIT_FAILURE);
    }

    memset(&sa, 0, sizeof(sa));
    strcpy(ifr.ifr_name, device);
    if (ioctl(fd, SIOCGIFINDEX, &ifr) < 0)
    {
        printf("choked");
        exit (EXIT_FAILURE);
    }
    sa.sll_family = AF_PACKET;
    sa.sll_ifindex = ifr.ifr_ifindex;
    sa.sll_protocol = htons(ETH_P_ALL);

    memset(&mr, 0, sizeof (mr));
    mr.mr_ifindex = sa.sll_ifindex;
    mr.mr_type = PACKET_MR_ALLMULTI;

    if (setsockopt(fd, SOL_PACKET, PACKET_ADD_MEMBERSHIP, (char *)&mr,
            sizeof (mr)) < 0)
    {
        printf("choked\n");
        exit (EXIT_FAILURE);
    }
    /* yay.  we made it and it workz! */
    printf("yes");
#else   /* PF_PACKET */
    printf("no");
#endif
    exit (EXIT_SUCCESS);
}
EOF
    ${CC-cc} -o pf_packet-test $CFLAGS pf_packet-test.c >/dev/null 2>&1

    # Oopz 4.3 BSD doesn't have this.  Sorry.
    if test ! -x ./pf_packet-test ; then
        ac_libnet_have_pf_packet=choked
    else
        ac_libnet_have_pf_packet=`./pf_packet-test`;
    fi

    if test $ac_libnet_have_pf_packet = choked; then
        AC_MSG_RESULT(test program choked... assuming no)
    elif test $ac_libnet_have_pf_packet = yes; then
        AC_DEFINE(HAVE_PF_PACKET)
        LIBNET_CONFIG_DEFINES="$LIBNET_CONFIG_DEFINES -DHAVE_PF_PACKET"
    fi

    if test $ac_libnet_have_pf_packet != choked; then
        AC_MSG_RESULT($ac_libnet_have_pf_packet)
    fi
    rm -f pf_packet-test* core core.pf_packet-test
    ;;
    esac])
])

dnl
dnl Looks for a previous libnet version and attempts to determine which verion
dnl it is.  Version 0.8 was the first version that actually knew internally
dnl what version it was.
dnl
dnl usage:
dnl
dnl     AC_LIBNET_CHECK_LIBNET_VERSION
dnl
dnl results:
dnl
dnl
dnl

AC_DEFUN(AC_LIBNET_CHECK_LIBNET_VER,
[
    AC_CHECK_LIB(net, build_ip, AC_MSG_CHECKING(version) \

changequote(<<, >>)dnl
    if [[ ! -f $LIB_PREFIX/libnet.a ]] ; then
changequote([, ])dnl
        AC_MSG_RESULT($LIB_PREFIX/libnet.a doesn't exist)
        AC_MSG_RESULT(previous libnet install lives elsewhere, you should probably find it)
    else
        __LIBNET_VERSION=`strings $LIB_PREFIX/libnet.a | grep "libnet version"\
                | cut -f3 -d" "`;\
        if test -z "$__LIBNET_VERSION"; then
            AC_MSG_RESULT(<0.8)
        else
            AC_MSG_RESULT($__LIBNET_VERSION)
        fi
    fi\
    )
])


dnl
dnl Checks to see if this linux kernel uses ip_sum or ip_csum
dnl (Pulled from queso)
dnl
dnl usage:
dnl
dnl     AC_LIBNET_CHECK_IP_CSUM
dnl
dnl results:
dnl
dnl     HAVE_STRUCT_IP_CSUM (DEFINED)
dnl

AC_DEFUN(AC_LIBNET_CHECK_IP_CSUM,
[
    AC_MSG_CHECKING([struct ip contains ip_csum])
    AC_TRY_COMPILE([
        #define __BSD_SOURCE
        #define _BSD_SOURCE
        #include <sys/types.h>
        #include <netinet/in.h>
        #include <netinet/in_systm.h>
        #include <netinet/ip.h>],
        [
            struct ip ip;
            ip.ip_csum = 0;
        ],
        [AC_MSG_RESULT(yes);
        AC_DEFINE(HAVE_STRUCT_IP_CSUM)],
        [AC_MSG_RESULT(no);
    ])
])

dnl
dnl Checks to see if unaligned memory accesses fail
dnl (Pulled from libpcap)
dnl
dnl usage:
dnl
dnl     AC_LBL_UNALIGNED_ACCESS
dnl
dnl results:
dnl
dnl     LBL_ALIGN (DEFINED)
dnl

AC_DEFUN(AC_LBL_UNALIGNED_ACCESS,
    [AC_MSG_CHECKING(if unaligned accesses fail)
    AC_CACHE_VAL(ac_cv_lbl_unaligned_fail,
        [case "$target_cpu" in

        alpha|hp*|mips|sparc)
                ac_cv_lbl_unaligned_fail=yes
                ;;

        *)
                cat >conftest.c <<EOF
#                   include <sys/types.h>
#                   include <sys/wait.h>
#                   include <stdio.h>
                    unsigned char a[[5]] = { 1, 2, 3, 4, 5 };
                    main()
                    {
                        unsigned int i;
                        pid_t pid;
                        int status;
                        /* avoid "core dumped" message */
                        pid = fork();
                        if (pid <  0)
                        {
                            exit(2);
                        }
                        if (pid > 0)
                        {
                            /* parent */
                            pid = waitpid(pid, &status, 0);
                            if (pid < 0)
                            {
                                exit(3);
                            }
                            exit(!WIFEXITED(status));
                        }
                        /* child */
                        i = *(unsigned int *)&a[[1]];
                        printf("%d\n", i);
                        exit(0);
                    }
EOF
                ${CC-cc} -o conftest $CFLAGS $CPPFLAGS $LDFLAGS \
                    conftest.c $LIBS > /dev/null 2>&1
                # Oopz 4.3 BSD doesn't have this.  Sorry.
                if test ! -x conftest ; then
                        dnl failed to compile for some reason
                        ac_cv_lbl_unaligned_fail=yes
                else
                        ./conftest > conftest.out
                        if test ! -s conftest.out ; then
                                ac_cv_lbl_unaligned_fail=yes
                        else
                                ac_cv_lbl_unaligned_fail=no
                        fi
                fi
                rm -f conftest* core core.conftest
                ;;
        esac])
    AC_MSG_RESULT($ac_cv_lbl_unaligned_fail)
    if test $ac_cv_lbl_unaligned_fail = yes ; then
            AC_DEFINE(LBL_ALIGN)
    fi
])


dnl
dnl Checks endianess
dnl
dnl usage:
dnl
dnl     AC_LIBNET_ENDIAN_CHECK
dnl
dnl results:
dnl
dnl     LIBNET_BIG_ENDIAN = 1   or
dnl     LIBNET_LIL_ENDIAN = 1
dnl

AC_DEFUN(AC_LIBNET_ENDIAN_CHECK,
    [AC_MSG_CHECKING(machine endianess)

    cat > conftest.c << EOF
#       include <stdio.h>
#       include <stdlib.h>

        int main()
        {
            union
            {
                short s;
                char c[[sizeof(short)]];
            } un;

            un.s = 0x0102;
            if (sizeof (short) == 2)
            {
                if (un.c [[0]] == 1 && un.c [[1]] == 2)
                {
                    printf("B\n");
                }
                else
                {
                    if (un.c [[0]] == 2 && un.c [[1]] == 1)
                    {
                        printf("L\n");
                    }
                }
            }
            else
            {
                printf("?\n");
            }
            return (EXIT_SUCCESS);
        }
EOF
        ${CC-cc} -o conftest $CFLAGS $CPPFLAGS $LDFLAGS conftest.c $LIBS > /dev/null 2>&1
        # Oopz 4.3 BSD doesn't have this.  Sorry.
        if test ! -x conftest ; then
dnl failed to compile for some reason
            ac_cv_libnet_endianess=unknown
        else
            ./conftest > conftest.out
            result=`cat conftest.out`
            if test $result = "B"; then
                ac_cv_libnet_endianess=big
            elif test $result = "L"; then
                ac_cv_libnet_endianess=lil
            else
                ac_cv_libnet_endianess=unknown
            fi                                
        fi
        rm -f conftest* core core.conftest

        AC_MSG_RESULT($ac_cv_libnet_endianess)

        if test $ac_cv_libnet_endianess = big ; then
            AC_DEFINE(LIBNET_BIG_ENDIAN)
        LIBNET_CONFIG_DEFINES="$LIBNET_CONFIG_DEFINES -DLIBNET_BIG_ENDIAN"
        elif test $ac_cv_libnet_endianess = lil ; then
            AC_DEFINE(LIBNET_LIL_ENDIAN)
        LIBNET_CONFIG_DEFINES="$LIBNET_CONFIG_DEFINES -DLIBNET_LIL_ENDIAN"
        fi
    ])

dnl
dnl Check snprintf for overrun potential
dnl

AC_DEFUN(DPS_SNPRINTF_OFLOW,
[AC_MSG_CHECKING(whether snprintf ignores n)
AC_CACHE_VAL(dps_cv_snprintf_bug,
[AC_TRY_RUN(
changequote(<<, >>)dnl
<<#include <stdio.h>

    #ifndef HAVE_SNPRINTF
    #ifdef HAVE_VSNPRINTF
    #include "vsnprintf.h"
    #else /* not HAVE_VSNPRINTF */
    #include "vsnprintf.c"
    #endif /* HAVE_VSNPRINTF */
    #endif /* HAVE_SNPRINTF */

    int main(void)
    {
        char ovbuf[7];
        int i;

        for (i = 0; i < 7; i++) ovbuf[i] = 'x';
        snprintf(ovbuf, 4,"foo%s", "bar");
        if (ovbuf[5] != 'x') exit(1);
        snprintf(ovbuf, 4,"foo%d", 666);
        if (ovbuf[5] != 'x') exit(1);
        exit(0);
    } >>
    changequote([, ]), dps_cv_snprintf_bug=0, dps_cv_snprintf_bug=1,
        dps_cv_snprintf_bug=2)])
    if test $dps_cv_snprintf_bug -eq 0 ; then
        AC_MSG_RESULT([no, snprintf is ok])
    elif test $dps_cv_snprintf_bug -eq 1 ; then
        AC_MSG_RESULT([yes, snprintf is broken])
        AC_DEFINE(HAVE_SNPRINTF_BUG)
    else
        AC_MSG_RESULT([unknown, assuming yes])
        AC_DEFINE(HAVE_SNPRINTF_BUG)
    fi])

dnl Check vsnprintf for overrun potential
AC_DEFUN(dps_vsnprintf_oflow,
[AC_MSG_CHECKING(whether vsnprintf ignores n)
AC_CACHE_VAL(dps_cv_vsnprintf_bug,
[AC_TRY_RUN(
changequote(<<, >>)dnl
<<#include <stdio.h>
#include <stdarg.h>

#ifndef HAVE_VSNPRINTF
#include "vsnprintf.c"
#endif /* HAVE_VSNPRINTF */

int prnt(char *s, const char *fmt, ...)
{
  va_list argp;
  va_start(argp, fmt);
  vsnprintf(s, 4, fmt, argp);
  va_end(argp);
}

int main(void)
{
  char ovbuf[7];
  int i;
  for (i=0; i<7; i++) ovbuf[i]='x';
  prnt(ovbuf, "foo%s", "bar");
  if (ovbuf[5]!='x') exit(1);
  prnt(ovbuf, "foo%d", 666);
  if (ovbuf[5]!='x') exit(1);
  exit(0);
} >>
changequote([, ]), dps_cv_vsnprintf_bug=0, dps_cv_vsnprintf_bug=1,
dps_cv_vsnprintf_bug=2)])

if test $dps_cv_vsnprintf_bug -eq 0; then
  AC_MSG_RESULT([no, vsnprintf is ok])
else if test $dps_cv_vsnprintf_bug -eq 1; then
  AC_MSG_RESULT([yes, vsnprintf is broken])
  AC_DEFINE(HAVE_VSNPRINTF_BUG,1)
else
  AC_MSG_RESULT([unknown, assuming yes])
  AC_DEFINE(HAVE_VSNPRINTF_BUG,1)
fi; fi])

dnl open and symlink interaction bug test
AC_DEFUN(dps_symlink_open_bug,
[AC_MSG_CHECKING(security of interaction between symlink and open)
AC_CACHE_VAL(dps_cv_symlink_open_bug,
[mkdir conftest.d
AC_TRY_RUN(
changequote(<<, >>)dnl
<<#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_ERRNO_H
#include <errno.h>
#else
extern int errno;
#endif

int main(void)
{
  int fd;
  if (chdir("conftest.d")!=0)
    exit(1);
  if (symlink("foo","bar")!=0)
    exit(1);
  if ((fd=open("bar", O_CREAT | O_EXCL | O_WRONLY, 0700))==0)
  {
        write(fd, "If the symlink was to .rhosts you would be unhappy", 50);
	close(fd);
	exit(1);
  }
  if (errno!=EEXIST)
    exit(1);
  exit(0);
} >>
changequote([, ]), cps_cv_symlink_open_bug=0,
[if test -r conftest.d/foo; then
  cps_cv_symlink_open_bug=2
else
  cps_cv_symlink_open_bug=1
fi], cps_cv_symlink_open_buf=3)
rm -rf conftest.d])
case "$cps_cv_symlink_open_bug" in
0) AC_MSG_RESULT(secure) ;;
1) AC_MSG_RESULT(errno wrong but ok)
   AC_DEFINE(HAVE_SYMLINK_OPEN_ERRNO_BUG) ;;
2) AC_MSG_RESULT(insecure)
   AC_DEFINE(HAVE_SYMLINK_OPEN_SECURITY_HOLE)
   AC_DEFINE(HAVE_SYMLINK_OPEN_ERRNO_BUG) ;;
3) AC_MSG_RESULT(assuming insecure)
   AC_DEFINE(HAVE_SYMLINK_OPEN_SECURITY_HOLE)
   AC_DEFINE(HAVE_SYMLINK_OPEN_ERRNO_BUG) ;;
*) AC_MSG_RESULT($cps_cv_symlink_open_bug)
   AC_MSG_ERROR(Impossible value of cps_cv_symlink_open_bug) ;;
esac])

dnl Check to RLIMIT_NPROC resource limit
AC_DEFUN(dps_rlimit_nproc,
[AC_MSG_CHECKING(for working RLIMIT_NPROC resource limit)
AC_CACHE_VAL(dps_cv_rlimit_nproc,
[AC_TRY_RUN(
changequote(<<, >>)dnl
<<
#ifndef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#ifndef HAVE_SIGNAL_H
#include <signal.h>
#endif /* HAVE_SIGNAL_H */
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif /* HAVE_SYS_RESOURCE_H */

int main(void)
{
#ifdef RLIMIT_NPROC
    static const struct rlimit pid_lim={RLIMIT_NPROC, 1};
    pid_t f;

    signal(SIGCHLD, SIG_IGN);
    setrlimit(RLIMIT_NPROC, (struct rlimit *) &pid_lim);
    if ((f=fork())==0)
	exit(0);
    if (f==-1)
	exit(0); /* The fork() failed (the right thing) */
#endif
   exit(1);
} >>
changequote([, ]), cps_cv_rlimit_nproc=0, cps_cv_rlimit_nproc=1,
cps_cv_rlimit_nproc=2)])
if test $cps_cv_rlimit_nproc -eq 0; then
  AC_MSG_RESULT([yes])
  AC_DEFINE(HAVE_RLIMIT_NPROC,1)
else if test $cps_cv_rlimit_nproc -eq 1; then
  AC_MSG_RESULT([no])
else
  AC_MSG_RESULT([unknown, assuming none])
fi; fi])

dnl Check to RLIMIT_MEMLOCK resource limit
AC_DEFUN(cps_rlimit_memlock,
[AC_MSG_CHECKING(for RLIMIT_MEMLOCK resource limit)
AC_CACHE_VAL(cps_cv_rlimit_memlock,
[AC_TRY_RUN(
changequote(<<, >>)dnl
<<
#ifndef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#ifndef HAVE_SIGNAL_H
#include <signal.h>
#endif /* HAVE_SIGNAL_H */
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif /* HAVE_SYS_RESOURCE_H */
#ifdef HAVE_SYS_MMAN
#include <sys/mman.h>
#endif /* HAVE_SYS_MMAN */
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif /* HAVE_ERRNO_H */

int main(void)
{
#ifdef RLIMIT_MEMLOCK
    static const struct rlimit mlock_lim={RLIMIT_MEMLOCK, 0};
    void *memory;

    if (setrlimit(RLIMIT_MEMLOCK, (struct rlimit *) &mlock_lim)!=-1)
	exit(0);
#endif
exit(1);
} >>
changequote([, ]), cps_cv_rlimit_memlock=0, cps_cv_rlimit_memlock=1,
cps_cv_rlimit_memlock=2)])
if test $cps_cv_rlimit_memlock -eq 0; then
  AC_MSG_RESULT([yes])
  AC_DEFINE(HAVE_RLIMIT_MEMLOCK,1)
else if test $cps_cv_rlimit_memlock -eq 1; then
  AC_MSG_RESULT([no])
else
  AC_MSG_RESULT([unknown, assuming none])
fi; fi])
