/*
Copyright (c) 1999 Rafal Wojtczuk <nergal@avet.com.pl>. All rights reserved.
See the file COPYING for license details.
*/

#ifndef _NIDS_NIDS_H
#define _NIDS_NIDS_H
#ifdef COMPILING_LIBNIDS
#include "util.h"
#include "tcp.h"
#endif
struct tuple4
{
unsigned short source,dest;
unsigned long saddr,daddr;
};
struct half_stream
{
char state,collect,collect_urg;
char * data;
int offset,count,count_new,bufsize,rmem_alloc;
int urg_count;
unsigned int acked;
unsigned int seq,ack_seq,first_data_seq;
unsigned char urgdata,count_new_urg,urg_seen;
unsigned int urg_ptr;
unsigned short window;
struct skbuff * list,*listtail;
};
struct tcp_stream
{
struct tuple4 addr;
char nids_state;
struct lurker_node * listeners;
struct half_stream client,server;
struct tcp_stream * next_node;
struct tcp_stream * prev_node;
int hash_index;
struct tcp_stream * next_time;
struct tcp_stream * prev_time;
int read;
struct tcp_stream * next_free;
};

struct nids_prm
{
int n_tcp_streams;
int n_hosts;
char * device;
int sk_buff_size;
int dev_addon;
void (*syslog)();
int syslog_level;
int scan_num_hosts;
int scan_delay;
int scan_num_ports;
void (*no_mem)(char*);
int (*ip_filter)();
};
extern struct nids_prm nids_params;

int nids_init();
void nids_run();
void nids_register_tcp(void(*));
void nids_register_ip(void(*));
void nids_register_ip_frag(void(*));
void nids_killtcp(struct tcp_stream*);
void nids_discard (struct tcp_stream *, int);
extern int nids_getfd();
extern char *nids_warnings[];
extern char nids_errbuf[];

enum {
NIDS_WARN_IP=1,
NIDS_WARN_TCP,
NIDS_WARN_UDP,
NIDS_WARN_SCAN
};

enum 
{
NIDS_WARN_UNDEFINED=0,
NIDS_WARN_IP_OVERSIZED,
NIDS_WARN_IP_INVLIST,
NIDS_WARN_IP_OVERLAP,
NIDS_WARN_IP_HDR,
NIDS_WARN_IP_SRR,
NIDS_WARN_TCP_TOOMUCH,
NIDS_WARN_TCP_HDR,
NIDS_WARN_TCP_BIGQUEUE,
NIDS_WARN_TCP_BADFLAGS
};


#define NIDS_JUST_EST 1
#define NIDS_DATA 2
#define NIDS_CLOSE 3
#define NIDS_RESET 4
#define NIDS_TIMED_OUT 5

#endif
