#include "nids.h"
#if (HAVE_NEW_PCAP)
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <sys/ioctl.h>

int set_all_promisc()
{
	struct ifreq ifaces[16];
	struct ifconf param;
	int sock, i;
	param.ifc_len = sizeof(ifaces);
	param.ifc_req = ifaces;
	sock = socket(PF_INET, SOCK_DGRAM, IPPROTO_IP);
	if (sock <= 0)
		return 0;
	if (ioctl(sock, SIOCGIFCONF, &param))
		return 0;
	for (i = 0; i < param.ifc_len / sizeof(struct ifreq); i++) {
		if (ioctl(sock, SIOCGIFFLAGS, ifaces + i))
			return 0;
		ifaces[i].ifr_flags |= IFF_PROMISC;
		if (ioctl(sock, SIOCSIFFLAGS, ifaces + i))
			return 0;
	}
	return 1;
}

#endif
