#!/usr/bin/perl
#
# cleanup.pl         - SHADOW Version 1.6
#                      Last changed 29 Sep 1999
#
#  Script to clean up the directory on the SENSOR to prevent loss of data 
#  due to a disk partition filling up. 
#  This script will be run by cron nightly.
#  
#  Written by Bill Ralph 2/24/98
#  Re-written by Bill Ralph in Perl 3/12/98
#  Y2K mods 7/2/1999
#
# Set up some variables.
#
use Getopt::Long;
use POSIX qw(strftime);
#
$SHADOW_PATH = "/usr/local/logger";
$ENV{PATH} = "/bin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin:$SHADOW_PATH";

#
sub usage {
        print "Usage: cleanup.pl [-debug] -d YYYYMMDD -l Site.\n";
        exit 2;
}
#
#	Parse the parameters.
#
&GetOptions("debug", \$debug, "d:s", \$clean_date, "l=s", \$Site);
$date_len = length($clean_date);
#
# Parse the $clean_date  into its subcomponents.
#
if ($clean_date) {
#
# Play with the $clean_date parameter so we understand what's happening.
#
   exit 2 if ($date_len < 6);
   $yr_format = ($date_len == 8) ? "a4a2a2a2" : "a2a2a2a2";
   ($year, $mon, $mday) = unpack($yr_format, $clean_date);
   $mon -= 1;
   if (!($yr_format =~ /4/)) {
#
# Let's try a "sliding window" here: If the year > 90, assume 20th century.
#                                    If the year < 20, assume 21 century.
#
      $clean2_date = $clean_date;
      if ($year > 90) {
         $clean4_date = "19" . $clean_date;
      } elsif ($year < 20) {
         $year += 100;
         $clean4_date = "20" . $clean_date;
      }
   }
   $subdir = strftime("%b%d", 0, 0, 0, $mday, $mon, $year, 0, 0, 0);
} else {
   $clean4_date = $clean_date;
   $clean2_date = substr($clean4_date,2);
}
##
#
#  Rid ourselves of standard output and error to prevent tons of mail messages
#  from cron.
#
@lvls = split(/\//,$0);				# Split path
($call, $suf) = split(/\./, $lvls[$#lvls]);	# Split call.suffix
$LOG_FILE = $debug ? "/tmp/$call.log" : "/dev/null";
open(STDOUT, ">>$LOG_FILE");
select STDOUT; $| = 1;
open(STDERR, ">&STDOUT");
select STDERR; $| = 1;              # make unbuffered
#
# Writer a marker to the log file.
#
$marker=strftime("%c", localtime(time));
chomp $marker;
print STDOUT $marker;
foreach $param ($0, @ARGV) {
   printf " %s", $param;
}
print STDOUT "\n";
#

   print STDOUT "Command line: d = $clean_date \n";
   print STDOUT "Command line: l = $Site \n";

#  
#
# Once the Site is identified from the command line,
# load the needed external Parameters.
#
unshift(@INC, "$SHADOW_PATH/sites");
require "${Site}.ph";

#
# If the $clean_date is specified in the call, use it, otherwise
# use the default specified in the site-specific .ph file.
#
$clean4_date = $CLEAN4_DATE unless ($clean4_date);
$clean2_date = $CLEAN2_DATE unless ($clean2_date);
print STDOUT "clean4_date = $clean4_date\n";
print STDOUT "clean2_date = $clean2_date\n";

#
#
# Remove the files matching our clean_date
#
$file_pat2 = "$SENSOR_DIR/tcp.$clean2_date??.gz";
$file_pat4 = "$SENSOR_DIR/tcp.$clean4_date??.gz";
$cmd="df $SENSOR_DIR;rm $file_pat2;rm $file_pat4;df $SENSOR_DIR";
$cmd='"' . $cmd . '"';

   print STDOUT "Removing $file_pat2 $file_pat4 from $SENSOR.\n";
   print STDOUT ("ssh -l root $SENSOR $cmd\n");

   system ("ssh -l root $SENSOR $cmd");

#
