#! /usr/bin/perl
#
# find_scan.pl         - SHADOW Version 1.6
#                        Last changed 21 Sep 1999
#
#
# Originally written by Vicki Irwin, 
# "One of the nation's top intrusion detection analysts."
# formerly of the Naval Surface Warfare Center.
#
# Modified by Bill Ralph, "One of those highly (over) paid government 
# contractors."
#
#this program requires three command line arguments:
#the first is the site name
#the second is the raw data file to be input  
#the third is PID of the parent perl interpreter for a file name.
# Script Modified to fetch $SCAN_THRESHHOLD from external Param file.
#
$Site = $ARGV[0];
#
# Once the Site is identified from the command line,
# load the needed external Parameters.
#
$SHADOW_PATH = "/usr/local/logger";
unshift(@INC, "$SHADOW_PATH/sites");
require "${Site}.ph";

$filterfile = "$FILTER_DIR/filter.getall";

$fileinraw = $ARGV[1];
$pid = $ARGV[2];

$tcpdump_command = "gunzip -c $fileinraw|tcpdump -r - -n -t -F $filterfile|sort -u";

print STDOUT "Scanning output ... \n";
open(RAWFILE,"$tcpdump_command|");

$linenum = 0;

print STDOUT "Searching for scans ....\n";

while(<RAWFILE>) 
{
    next if /gre-proto/;
    next if /trunc/;
    $line = $_;
    $linenum = $linenum + 1;
    @fields = split(/\s+/, $line);
    
    @srcoctets = split(/\./,$fields[0]);
    $srcip = "$srcoctets[0].$srcoctets[1].$srcoctets[2].$srcoctets[3]";
    
    
    @dstoctets = split(/\./,$fields[2]);
    $dstoctets[3] =~ tr/://d;
    $dstip = "$dstoctets[0].$dstoctets[1].$dstoctets[2].$dstoctets[3]";
    
   
    $srciphash{$srcip}{$dstip} = 1;
    if ($linenum%10000 == 0) {print STDOUT "Line number ",$linenum," processed....\n";}
}
close(RAWFILE);



print STDOUT "Analyzing output....\n";

foreach $srcip (keys(%srciphash))
{
   $howmany = 0;
   foreach $dstip (keys(%{$srciphash{$srcip}}))
   {
      $howmany += $srciphash{$srcip}{$dstip};
   }
   if ($howmany >= $SCAN_THRESHHOLD)
   {
      $outputhash{$srcip} = $howmany;
   }
}


@sortedips = sort by_ip keys(%outputhash);



print STDOUT "Writing output file .....\n";

$output_filename = "/tmp/${Site}_${pid}.results";
open (OUT,">$output_filename");
printf(OUT "%-10s %-17s %-50s \n\n","num dests","source ip","source name");
foreach $srcip (@sortedips)
{
    @srcoctets = split(/\./, $srcip);
    $binip = pack "c4",$srcoctets[0],$srcoctets[1],$srcoctets[2],$srcoctets[3];
    @info = gethostbyaddr($binip,2);
    $srcname = $info[0];
    
    printf(OUT "%-10d %-17s %-50s \n", $outputhash{$srcip},$srcip,$srcname,"\n");
}
close(OUT);


print STDOUT "Results are in file /tmp/${Site}_${pid}.results\n";


sub by_ip
{
    @avec = split(/\./ , $a);
    @bvec = split(/\./ , $b);

    $avec[0] <=> $bvec[0]
        or
    $avec[1] <=> $bvec[1]
        or
    $avec[2] <=> $bvec[2]
        or
    $avec[3] <=> $bvec[3]
}

