#!/usr/bin/perl
#
# compose_IR.cgi         - SHADOW Release 1.6
#                          Last Changed 12 November 1999
#
use CGI qw/:all/;
use CGI::Carp qw(fatalsToBrowser);
use POSIX qw(strftime);
use Time::Local;
#
# Use /tmp/IR_seq for sequence number if testing the script.
#
#$IR_SEQNO_FILE = "/tmp/IR_seq";
#$IR_DATA_FILE = "/tmp/Incident-Reports";
$IR_SEQNO_FILE = "/usr/local/etc/httpd/cgi-bin/IR_seq";
$IR_DATA_FILE = "/var/spool/SHADOW/Incident-Reports";
#
# Define some "constants" for the file locking calls.
#
   $LOCK_SH = 1;
   $LOCK_EX = 2;
   $LOCK_NB = 4;
   $LOCK_UN = 8;
   
#
sub fetch_seqno
{
# Read a file for an IR sequence number for todays date. Do not modify the 
# file at this point. That will be done when the form is submitted.
#
# Written by Bill Ralph - 25 Jan 1999
#
#
# Calculate the IR sequence number from todays date.
#
   $todays_date = strftime("%Y%m%d", localtime);
   $todays_prefix = "GGI-IDR${todays_date}";
   $todays_seq = 1;
   if (open(SEQ_FILE, "<${IR_SEQNO_FILE}")) {
      my $line = <SEQ_FILE>;
      (my $prefix, my $seq) = split(/\./,$line);
      if ($prefix eq $todays_prefix) {
         $todays_seq = $seq + 1;
      }
   }
   my $new_seqno = "${todays_prefix}.${todays_seq}";
   return $new_seqno;
}
#
sub update_seqno
{
# Read a file for an IR sequence number for todays date. If it exists, 
# increment and resave it. If not create the file, create the seq no, and 
# save it.
#
# Written by Bill Ralph - 12/29/98
#
#
# Calculate the IR sequence number from todays date.
#
   $todays_date = strftime("%Y%m%d", localtime);
   $todays_prefix = "GGI-IDR${todays_date}";
   $todays_seq = 1;
   $new_seqno = "${todays_prefix}.${todays_seq}";
   if (-s ${IR_SEQNO_FILE}) {
      open(SEQ_FILE, "+<${IR_SEQNO_FILE}")
          or die("Unable to open IR Sequence file");
      flock(SEQ_FILE, $LOCK_EX);
      my $line = <SEQ_FILE>;
      (my $prefix, my $seq) = split(/\./,$line);
      if ($prefix eq $todays_prefix) {
         $todays_seq = $seq + 1;
      }
      $new_seqno = "${todays_prefix}.${todays_seq}";
      seek(SEQ_FILE, 0, 0);
      print SEQ_FILE "$new_seqno\n";
      close(SEQ_FILE);
      flock(SEQ_FILE, $LOCK_UN);
   } else {
      open(SEQ_FILE, ">${IR_SEQNO_FILE}")
          or die("Unable to create IR Sequence file");
      $new_seqno = "${todays_prefix}.${todays_seq}";
      print SEQ_FILE "$new_seqno\n";
      close(SEQ_FILE);
   }
   return $new_seqno;
}
#
#
#
$today = strftime("%a %b %d, %Y - %T", localtime(time));
print header,
start_html(-title=>'Create an Incident Report',
           -author=>'Ima.Goodguy@goodguys.com',
           -bgcolor=>'#D2FFD2',
          );
if (!param) {
   $shadow_seqno = fetch_seqno();
   print start_form(-target=>'_self'),
   h3({-align=>CENTER}, "GoodGuys Industries - Network Detection Report"),
   "GoodGuys Report No.: ",
   textfield(-name=>'rep_num',
             -size=>23,
             -value=>$shadow_seqno),
   p(),
   "   Mail Recipients: ",
   textfield(-name=>'mailto',
             -size=>30,
             -value=>'IR_Recipients'),
   p(),
   "1. Report Date: $today", 
   p(),
   "2. Incident Date: ",
   textfield(-name=>'inci_date',
             -size=>20),
   p(),
   "3. Type of Incident: ",
   scrolling_list(-name=>'inci_type',
                  -size=>1,
                  -values=>['Denial of Service Attack', 'IMAP Attack', 
                  'TraceRoute-Like Probe', 'Illegal Remote Login Attempts', 
                  'RESET Scan', 'SYN Scan', 'SYN/RST Scan', 'FTP Scan',
                  'Back Orifice Exploit Attempt', 'Port Scan', 'POP3 Scan', 
                  'SNMP Probe/Scan', 'RPC/Portmap Attack',
                  'DNS Zone Transfer', 'Single System Scan/Probe', 
                  'SOCKS Exploit', 'Informational Report',
                  'Multiple Port Scan/Attacks - Multiple Targets', 
                  'Foreign Access Attempt', 'Network Mapping Attempt', 
                  'Unknown Probe type','ICMP Scan', 'NetBus Exploit',
                  'TCPMUX Scan', 'NETBIOS Probe'],
                  -default=>'Informational Report'),
   p(),
   "4. Individuals Involved: ",
   p("Source: ",
   textfield(-name=>'inci_source', -size=>35)),
   p("Target(s): ",
   textfield(-name=>'inci_target', -size=>35)),
   p("Site: ", 
   scrolling_list(-name=>'site',
                  -size=>1,
                  -values=>['GoodGuys Industries, Inc. (GGII)',
                  'Network Utility Testing Service (NUTS)', 
                  'Fast Utility Development for a Green Environment (FUDGE)', 
                  'United States Bureacracy System (USBS)'], 
                  -default=>'GoodGuys Industries, Inc. (GGII)')),
   p(),
   "5. Cost of this Incident: ",
   textfield(-name=>'inci_cost',
             -size=>20,
             -value=>'No Downtime.'),
   p(),
   "6. Summary of Incident and Investigation Results: ",
   p(),
   textarea(-name=>'summary',
            -rows=>10,
            -cols=>80,
            -wrap=>'physical'),
   p(),
   submit(-name=>'IR', -value=>'Send It'),
   end_form;
} else {
   $recipients = param('mailto');
#
# Comment out the following statement if testing this script.
#
   $rep_num = update_seqno();
   $inci_date = param('inci_date');
   $inci_type = param('inci_type');
   $site = param('site');
   $inci_source = param('inci_source');
   $mail_subject = "$rep_num  : ${src_txt}${inci_type} \@ $site";
   $inci_target = param('inci_target');
   $inci_cost = param('inci_cost');
   $inci_summ = param('summary');
   $inci_summ =~ tr/\r//d;
   $mail_cmd = "/usr/sbin/sendmail -t -oi";
#
# Create an array of lines of our mail message.
#
   @lines = split(/\n/, <<"EOF" );
To: $recipients
From: The GoodGuys SHADOW Team <shadow\@goodguys.com>
Subject: $mail_subject

                  GoodGuys Industries - Network Security Division
                            Network Detection Report

                               Phone 000-555-1212

GGII Intrusion Detection Report No.: $rep_num

   1. Report Date: $today
   2. Incident Date: $inci_date
   3. Type of Incident: $inci_type
   4. Individuals Involved: 
         ${src_txt}Source: $inci_source
         Target(s): $inci_target  Site: $site
   5. Cost of this Incident: $inci_cost
   6. Summary of Incident and Investigation Results: 

$inci_summ

***** End of GGI Intrusion Detection Report No.: $rep_num *****
EOF
#
# Copy the array of lines to the sendmail command and the database of
# Incident Reports we're saving.
#
   open(IRDATA, ">>$IR_DATA_FILE");
#
# Make sure we have exclusive access to the data file.
#
   flock(IRDATA, $LOCK_EX);
   open(MAILCMD, "|$mail_cmd");
   foreach $line (@lines) {
      print IRDATA "$line\n";
      print MAILCMD "$line\n";
   }
   close(IRDATA);
   flock(IRDATA, $LOCK_UN);
   close(MAILCMD);
#
# print the web page to show user the mail was sent.
#
   print 
         a({-name=>'print', -href=>'javascript:window.print()'},
         img({-align=>'right',-src=>'/images/print.jpg',-border=>'0'})),
         h3({-align=>CENTER},"GoodGuys Industries - Network Security Division"),
         h3({-align=>CENTER}," Intrusion Detection Report"), 
         p(),
         hr(),
         center(strong("Phone 000-555-1212")), 
         p(),
         center(strong("GGII Intrusion Detection Report No.:")," $rep_num"), 
         p(),
         p(),
         strong("Sent To: $recipients"),
         p(),
         strong("Mail Subject: $mail_subject"),
         hr(),
         p(),
         strong("1. Report Date: "), "$today", p(),
         strong("2. Incident Date: "), "$inci_date", p(),
         strong("3. Type of Incident: "), "$inci_type", p(),
         strong("4. Individuals Involved: "), p(),
         ul(
         li(strong("${src_txt}Source:"), "$inci_source"), 
         li(strong("Target(s): "), "$inci_target", strong("  Site: "), "$site"),
         ),
         strong("5. Cost of this Incident: "),"$inci_cost", p(),
         p(),
         strong("6. Summary of Incident and Investigation Results: "), p(),
         p(),
         pre("$inci_summ"), p(),
         hr(),
         h3({-align=>CENTER}," Mail sent.");
}
print end_html;
