#!/usr/bin/perl
#
# lookup.cgi        - SHADOW Release 1.6
#                     Last Changed 7 Sep 1999
#
use CGI qw/:standard/;
use CGI::Carp qw(fatalsToBrowser);
use POSIX qw(strftime);
use Time::Local;
#
$today = strftime("%a %b %d, %Y - %T", localtime(time));
$shadow_prefix = strftime("SHA%y%m%d.", localtime(time));
print header,
start_html(-title=>'DNS Lookup Name/Address Information',
           -author=>'Ima.Goodguy@goodguys.com',
           -bgcolor=>'#D2FFD2',
          );
if (!param) {
   print h3({-align=>CENTER}, "Team SHADOW - NSLOOKUP Form"),
   start_form(-target=>'_self'),
   "Paste Name/IP Address Here: ",
   textfield(-name=>'search_field',
             -size=>45),
   p(),
   submit,
   end_form;
} else {
   select STDOUT; $| = 1;              # make unbuffered
   $search_field = param('search_field');
   if ($search_field =~ tr/A-Za-z0-9.-//cd) {
      # Print out some HTML here indicating failure
      print h1("Invalid search address.");
      print end_html;
      exit(1);
   }
   print h1("Your answers: "),
   " Seeking Info on: ", $search_field, "\n<PRE>\n";
   system('/usr/bin/nslookup', $search_field);
   print "</PRE>";
}
print end_html;
