#!/usr/bin/perl
#
# mday-search.cgi         - SHADOW Release 1.6
#                           Last Changed 15 Sep 1999
#
use CGI qw/:standard/;
use CGI::Carp qw(fatalsToBrowser);
use POSIX qw(strftime);
use Time::Local;
#
%month_no = (
   "Jan" => 0, "Feb" => 1, "Mar" => 2, "Apr" => 3, "May" => 4, "Jun" => 5,
   "Jul" => 6, "Aug" => 7, "Sep" => 8, "Oct" => 9, "Nov" => 10, "Dec" => 11);
$time_now = time;
@today = localtime($time_now);
$today_mday = strftime("%d", localtime(time));
$today_month = strftime("%h", localtime(time));
$today_year = strftime("%Y", localtime(time));
#
$group_pid = $$;
setpgrp($group_pid);
#
print header,
start_html(-title=>'Intrusion Detection pattern search',
           -author=>'Ima.Goodguy@goodguys.com',
           -bgcolor=>"#D2FFD2",
          );
if (!param) {
   print h1({-align=>CENTER}, "Multi-Day Search for a pattern in sensor logs."),
   start_form(-target=>'_self'),
   submit,
   p(),
   "Site: ", 
   radio_group(-name=>'site',
               -values=>['Site1','Site2','Site3','Site4', 'Site5'],
               -defaults=>['Site1']),
   p(),
   "Host Name Lookup: ", 
   radio_group(-name=>'nslookup',
               -values=>['Yes','No'],
               -default=>'Yes'),
   p(),
   "Start Search - Year: ",
   popup_menu(-name=>'beg_year',
              -values=>['1997','1998','1999','2000','2001'],
              -default=>$today_year),
   "Month: ",
   popup_menu(-name=>'beg_month',
              -values=>['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep',
                        'Oct','Nov','Dec'],
              -default=>$today_month),
   "Day of Month: ",
   popup_menu(-name=>'beg_day',
              -values=>['01','02','03','04','05','06','07','08','09','10','11',
                        '12','13','14','15','16','17','18','19','20','21','22',
                        '23','24','25','26','27','28','29','30','31'],
              -default=>$today_mday),
   p(),
   "End Search - Year: ",
   popup_menu(-name=>'end_year',
              -values=>['1997','1998','1999','2000','2001'],
              -default=>$today_year),
   "Month: ",
   popup_menu(-name=>'end_month',
              -values=>['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep',
                        'Oct','Nov','Dec'],
              -default=>$today_month),
   "Day of Month: ",
   popup_menu(-name=>'end_day',
              -values=>['01','02','03','04','05','06','07','08','09','10','11',
                        '12','13','14','15','16','17','18','19','20','21','22',
                        '23','24','25','26','27','28','29','30','31'],
              -default=>$today_mday),
   p(),
   "Search for a particular IP or 'host': ",
   textfield(-name=>'hostname',
             -size=>30),
   radio_group(-name=>'host_mod',
               -values=>['src','dst','either'],
               -default=>'either'),
   p(),
   radio_group(-name=>'port_join',
               -values=>['and','or'],
               -default=>'or'),
   "Search for a particular 'port': ",
   textfield(-name=>'port_num',
             -size=>10),
   radio_group(-name=>'port_mod',
               -values=>['src','dst','either'],
               -default=>'either'),
   p(),
   radio_group(-name=>'net_join',
               -values=>['and','or'],
               -default=>'or'),
   "Search for a particular IP or 'net': ",
   textfield(-name=>'netname',
             -size=>30),
   radio_group(-name=>'net_mod',
               -values=>['src','dst','either'],
               -default=>'either'),
   p(),
   radio_group(-name=>'gen_join',
               -values=>['and','or'],
               -default=>'or'),
   "Search for a general TCPDUMP format filter': ",
   textfield(-name=>'gen_pat',
             -size=>30),
   p(),
   submit,
   end_form;
} else {
   select STDOUT; $| = 1;              # make unbuffered
   $yr1 = param('beg_year') - 1900;
   $yr2 = param('end_year') - 1900;
   $beg_time = timelocal(0, 0, 0, param('beg_day'),
                         $month_no{param('beg_month')}, $yr1);
   @beg_date = localtime($beg_time);
   $end_time = timelocal(0, 0, 0, param('end_day'),
                         $month_no{param('end_month')}, $yr2);
   $end_time += 86400 if ($end_time == $beg_time);
   @end_date = localtime($end_time);
   $hostname = param('hostname');
   if ($hostname =~ tr/A-Za-z0-9.-//cd) {
      # Print out some HTML here indicating failure
      print h1("Invalid host/IP search field.");
      print end_html;
      exit(1);
   }
   $host_mod = param('host_mod');
   $port_join = param('port_join');
   $port_num = param('port_num');
   if ($port_num =~ tr/a-z0-9//cd) {
      # Print out some HTML here indicating failure
      print h1("Invalid port number.");
      print end_html;
      exit(1);
   }
   $port_mod = param('port_mod');
   $net_join = param('net_join');
   $netname = param('netname');
   if ($netname =~ tr/A-Za-z0-9.-//cd) {
      # Print out some HTML here indicating failure
      print h1("Invalid Net/IP address.");
      print end_html;
      exit(1);
   }
   $net_mod = param('net_mod');
   $gen_pat = param('gen_pat');
   $gen_join = param('gen_join');
#
#  Unfortunately, we can't generalize rules for specifying valid tcpdump
#  filters, since a lot of special characters are acceptable. Fortunately, we
#  call the script directly, i.e. no shell and enclose the tcpdump filter
#  in quotes.
#
   $site = param('site');
   $pattern = "";
   if ($hostname) {
      $pattern .= ($host_mod . " ")  if ($host_mod ne "either");
      $pattern .= "host " . $hostname . " ";
   }
   if ($port_num) {
      $pattern .= ($port_join . " ") if ($pattern);
      $pattern .= ($port_mod . " ") if ($port_mod ne "either");
      $pattern .= "port " . $port_num . " ";
   }
   if ($netname) {
      $pattern .= ($net_join . " ") if ($pattern);
      $pattern .= ($net_mod . " ")  if ($net_mod ne "either");
      $pattern .= "net " . $netname . " ";
   }
   if ($gen_pat) {
      $pattern .= ($gen_join . " ") if ($pattern);
      $pattern .= " " . $gen_pat . " ";
   }
   $lookup = (param('nslookup') eq 'Yes')?"":"-n";
   $bdate = strftime("%x", @beg_date);
   $edate = strftime("%x", @end_date);
   $kill_cmd = "/cgi-bin/kill_group.cgi?group_pid=${group_pid}";
   $perl_cmd = "/usr/local/logger/one_day_pat.pl";
   print 
   a({-name=>'kill',
      -href=>"$kill_cmd"},
       img({-align=>'left',-src=>'/images/abort.jpg',-border=>'0'})),
   a({-name=>'print', -href=>'javascript:window.print()'}, 
     img({-align=>'right',-src=>'/images/print.jpg',-border=>'0'})),
   h1("Your answers: "),
   " Site: $site Host lookup: $nslookup,  Dates: $bdate - $edate",
   " Pattern: ",$pattern,
   p();
   print STDOUT "\n<PRE>\n";
   for ($tim = $beg_time; $tim < $end_time; $tim += 86400) {
      @cur = localtime($tim);
      $date_param = strftime("%Y%m%d", @cur);
      $date = strftime("%x", @cur);
      $perl_cmd_params = "-S $lookup -d $date_param -l $site -p '$pattern'";
      $cmd = "${perl_cmd} ${perl_cmd_params}";
      open(SEARCH, "$cmd|") || die "Can't open search script: $!\n" ;
      while (<SEARCH>) {
         print STDOUT "$date $_";
      }
      close(SEARCH);
   }
   print STDOUT "\n</PRE>\n";
}
print end_html;
