#!/usr/bin/perl
#
#
# nmap.cgi             - SHADOW Release 1.6
#                        Last Changed 15 Sep 1999
#
use CGI qw/:standard/;
use CGI::Carp qw(fatalsToBrowser);
#
%scan_labels = ('-sT'=>"TCP Connect ", '-sS'=>"TCP SYN ", '-sF'=>"Stealth FIN ",
                '-sX'=>"Xmas Tree ", '-sN'=>"Null ", '-sP'=>"Ping ",
                '-sU'=>"UDP ");
%ping_labels = ('-P0'=>"No Ping ", '-PT'=>"TCP Ping ", '-PI'=>"ICMP Ping ",
                '-PB'=>"Both TCP and ICMP ");
print header,
start_html(-title=>'SHADOW NMAP Scan of offending IPs',
           -author=>'wralph@nswc.navy.mil',
           -bgcolor=>'#D2FFD2',
          );
#
if (!param) {
   print h1({-align=>CENTER}, "Perform an NMAP scan."),
   start_form(-target=>'_self'),
   p(),
   "Scan Type: ", 
   radio_group(-name=>'scan_type',
               -values=>['-sT','-sS','-sF','-sX', '-sN', '-sP', '-sU'],
               -defaults=>['-sS'],
               -labels=>\%scan_labels),
   p(),
   "Ping type: ", 
   radio_group(-name=>'ping_type',
               -values=>['-P0', '-PT', '-PI', '-PB'],
               -default=>'-PB',
               -labels=>\%ping_labels),
   p(),
   "Range of Ports to scan: ",
   textfield(-name=>'port_range',
             -size=>30, -value=>"DEFAULT"),
   p(),
   "Source Port to use: ",
   textfield(-name=>'src_port',
             -size=>12, -value=>"NMAP Choice"),
   p(),
   "Target selection: ",
   textfield(-name=>'target_field',
             -size=>30),
   p(),
   submit(-value=>"Scan 'em, Dano..."),
   end_form;
} else {
   select STDOUT; $| = 1;              # make unbuffered
   open(STDERR, ">&STDOUT");
   @nmap_params = ();
   $nmap_cmd = "/usr/local/bin/nmap";
   push @nmap_params, $nmap_cmd;
   push @nmap_params, "-vO";
   push @nmap_params, param('scan_type');
   push @nmap_params, param('ping_type');
   $port_range = param('port_range');
   if ($port_range ne "DEFAULT") {
      $port_range = "-p $port_range";
      push @nmap_params, $port_range;
   }
   $src_port = param('src_port');
   if ($src_port ne "NMAP Choice") {
      $src_port = "-g $src_port";
      push @nmap_params, $src_port;
   }
   $target_field =  "'" . param('target_field') . "'";
   push @nmap_params, $target_field;
   $cmd = "/usr/bin/sudo";
   $params = join(' ', @nmap_params);
   print 
   h1("NMAP command: "),
   "$cmd $params",
   h1("Results:"),
   p();
   print STDOUT "\n<PRE>\n";
   open(SCAN, "$cmd @nmap_params|") 
         || die "Can't open NMAP program: $!\n" ;
   while (<SCAN>) {
      print STDOUT $_;
   }
   close(SCAN);
   print STDOUT "\n</PRE>\n";
}
print end_html;
