#!/usr/bin/perl
#
# whois.cgi         - SHADOW Release 1.6
#                     Last Changed 7 Sep 1999
#
use CGI qw/:standard/;
use CGI::Carp qw(fatalsToBrowser);
use POSIX qw(strftime);
use Time::Local;
#
print header,
start_html(-title=>'Fetch Whois Information',
           -author=>'Ima.Goodguy@goodguys.com',
           -bgcolor=>'#D2FFD2',
          );
%labels = ('rs.internic.net'=>'NIC', 'whois.arin.net'=>'America',
           'whois.ripe.net'=>'Europe', 'whois.apnic.net'=>'Asia/Pacific',
           'whois.nic.mil'=>'MIL', 'whois.nic.gov'=>'GOV');
if (!param) {
   print h3({-align=>CENTER}, "Team SHADOW - WHOIS Form"),
   start_form(-target =>'_self'),
   "Paste Search field Here: ",
   textfield(-name=>'search_field',
             -size=>45),
   p("Which WHOIS server(s) do you want to query? "),
   checkbox_group(-name=>'server',
               -rows=>2,
               -values=>['rs.internic.net','whois.arin.net','whois.ripe.net',
                         'whois.apnic.net', 'whois.nic.mil', 'whois.nic.gov'],
               -labels=>\%labels,
               -defaults=>['whois.arin.net']),
   p(),
   submit(-name=>'whois',-value=>'Who is it?'),
   end_form;
} else {
   @servers = param('server');
   $search_field = param('search_field');
   select STDOUT; $| = 1;              # make unbuffered
#
#  Try to insure that our user sent some reasonable valid data.
#
#  if ($search_field =~ tr/A-Za-z0-9.-@*//cd) {
#     # Print out some HTML here indicating failure
#     print h1("Invalid search field.");
#     print end_html;
#     exit(1);
#  }
   print h1("Your answers: "),
   " Seeking Info on: ", $search_field, "\n<PRE>\n";
   foreach $server (@servers) {
      system('/usr/bin/whois', "$search_field\@${server}");
   }
   print "\n</PRE>";
}
print end_html;
