#!/usr/bin/perl
#
# one_day_pat.pl         - SHADOW Version 1.6
#                          Last changed 21 Sep 1999
#
#
#  Script to scan a tcpdump compressed hourly file using a pre-defined
#  tcpdump script. Parameters are: Date as YYMMDDHH and script name.
#  
#  Written by Bill Ralph 3/20/98
#
# Set up some variables.
#
use Getopt::Long;
use POSIX qw(strftime);
#
#
$SHADOW_PATH = "/usr/local/logger";
$ENV{PATH} = "/bin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin:$SHADOW_PATH";
#
sub usage {
        print "Usage: one_day_pat.pl {-n} {-d YYYYMMDD} {-l SITE} -p PATTERN.\n";
	exit 2;
}
#
#	Parse the parameters.
#
#
&GetOptions("n", \$no_lookup_flag, "d:s", \$snifdate, "l=s", \$Site,
            "p=s", \$pattern);
##
#
#  Check parameter validity.
#
$sdlen = length($snifdate);
if (("$Site" eq "") or ($pattern eq "") 
      or (($sdlen > 0) and ($sdlen != 8) and ($sdlen != 6)))
{
        usage();
}
$yr_format = ($sdlen == 6) ? "a2a2a2" : "a4a2a2"; 
#
# Once the Site is identified from the command line,
# load the needed external Parameters.
#
unshift(@INC, "$SHADOW_PATH/sites");
die ("No such site: ${Site}.") if ( ! -e "$SHADOW_PATH/sites/${Site}.ph");
require "${Site}.ph";

#
#
#
# If no snifdate specified on command line, assume today.
#
if ($snifdate eq "") {
   $snifdate = strftime("%Y%m%d", localtime);
}
#
#  Unpack the "snifdate" into its useful components.
#
($year, $mon, $mday) = unpack($yr_format, $snifdate);
$mon -= 1;
if (!($yr_format =~ /4/)) {
#
# Let's try a "sliding window" here: If the year > 90, assume 20th century.
#                                    If the year < 20, assume 21 century.
#
   if ($year > 90) {
      $snifdate = "19" . $snifdate;
   } elsif ($year < 20) {
      $year += 100;
      $snifdate = "20" . $snifdate;
   }
}
$subdir=strftime("%h%d", 0, 0, 0, $mday, $mon, $year, 0, 0, 0);
#
#  Set the no_lookup_flag to -n for tcpdump if it was specified on the calling
#  parameter list.
#
$no_lookup_flag = ($no_lookup_flag eq "1") ?"-n":"";
#
# Ready to start the work now, find the hourly data files.
#
#print STDOUT ("${ANALYZER_DIR}/${subdir}\n");
#
# 
chdir("${ANALYZER_DIR}/${subdir}");
@files=<tcp.*.gz>;
$pattern='"'.$pattern.'"';
#
die("No Raw Data Files.") if (int(scalar(@files)) == 0);
#
foreach $file (@files) {
   $cmd = "gunzip -c $file | tcpdump -S $no_lookup_flag -r - $pattern";
   open(COMMAND, "$cmd|") or die("Cannot start tcpdump process.");
   while (<COMMAND>) {
      print $_;
   }
   close(COMMAND);
}
