#!/usr/bin/perl
#
# pat_match.pl         - SHADOW Version 1.6
#                        Last changed 20 Sep 1999
#
#
#  Script to scan a tcpdump compressed hourly file using a command line 
#  furnished pattern match. 
#  
#  Written by Bill Ralph 3/11/98
#
# Set up some variables.
#
use Getopt::Long;
use POSIX qw(strftime);
#
$SHADOW_PATH = "/usr/local/logger";
$ENV{PATH} = "/bin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin:$SHADOW_PATH";

sub usage {
	print "Usage: pat_match.pl {-debug{ -n -d YYYYMMDD -l SITE -p PATTERN\n";
	exit 2;
}
#
#	Parse the parameters.
#
#
&GetOptions("debug", \$debug, "n", \$no_lookup_flag, "d:s", \$snifdate, "l=s", \$Site,"p=s" , \$pattern);
#
#
#  Check parameter validity.
#
if (("$Site" eq "") or ("$pattern" eq "") or (length($snifdate) < 8))
{
	usage();

}
##
#
#  Rid ourselves of standard output and error to prevent tons of mail messages
#  from cron.
#
@lvls = split(/\//,$0);				# Split path
($call, $suf) = split(/\./, $lvls[$#lvls]);	# Split call.suffix
$LOG_FILE = $debug ? "/tmp/$call.log" : "/dev/null";
open(STDOUT, ">>$LOG_FILE");
select STDOUT; $| = 1;
open(STDERR, ">&STDOUT");
select STDERR; $| = 1;              # make unbuffered

   print "n = $no_lookup_flag \n";
   print "d = $snifdate \n";
   print "l = $SITE \n";
   print "p = $pattern \n";

#
# Once the Site is identified from the command line,
# load the needed external Parameters.
#
unshift(@INC, "$SHADOW_PATH/sites");
require "${Site}.ph";

#
#  Set the no_lookup_flag to -n for tcpdump if it was specified on the calling
#  parameter list.
#

$no_lookup_flag = ($no_lookup_flag eq "1") ?"-n":"";
#
#  Unpack the "snifdate" into its useful components.
#
($year, $mon, $mday) = unpack("a4a2a2", $snifdate);
$mon -= 1;
$subdir=strftime("%h%d", 0, 0, 0, $mday, $mon, $year, 0, 0, 0);

   print "subdir = $subdir \n";

#
##
## Call tcpdump to read the uncompressed file and detect bad stuff.
##
$zipped_file="${ANALYZER_DIR}/$subdir/tcp.$snifdate.gz";
$pattern='"'.$pattern.'"';
#
$cmd = "gunzip -c $zipped_file | tcpdump -S $no_lookup_flag -r - $pattern";
print("$cmd\n");
#
open(COMMAND, "$cmd|") or die("Cannot start tcpdump process.");
while (<COMMAND>) {
   print $_;
}
close(COMMAND);

#
