#!/usr/bin/perl
#
# sensor_driver.pl - SHADOW release 1.6
#                    Last changed 03 Jan 2000
#
# main-wrapper for the tcpdump used in the SHADOW tool. Goes in as a root
# cron job like this (runs every hour on the hour):
#
# 0 * * * * /<suitable path here>/sensor_driver.pl std > /dev/null 2>&1
#
# The stop_logger.pl/start_logger.pl scripts complain if anything
# is wrong, so not much to do here except make sure the scripts we
# intend to run actually exist.
#
# Author: Olav Kolbu <olav.kolbu@usit.uio.no>
# Modifier: Bill Ralph <wralph@nswc.navy.mil>
#
# This code is hereby released into the public domain. It is released
# "as-is". All warranties disclaimed, implied or otherwise.
# 

# These are the external variables we need
$SENSOR_PATH = "/usr/local/logger/sensor";
unshift(@INC, $SENSOR_PATH);
  
# Refuse to do anything if stop_logger.pl or start_logger.pl isn't
# where we expect them to be.
#
die("'$SENSOR_PATH/stop_logger.pl' not found, aborting\n") 
  if ! -x "$SENSOR_PATH/stop_logger.pl";
die("'$SENSOR_PATH/start_logger.pl' not found, aborting\n") 
  if ! -x "$SENSOR_PATH/start_logger.pl";

#
# Added a calling parameter to specify the "variables" header file with
# needed parameter definitions. This easily allows different paths, values,
# and filters for particular situations. It should also allow multiple 
# tcpdumps to run on a single machine.
#
if ($ARGV[0] eq "ALL")
{
   chdir($SENSOR_PATH);
   @instances = <*.ph>;
} else {
   @instances = @ARGV;
}
foreach $instance (@instances)
{
   ($which, $rest) = split(/\./, $instance);
   die ("No such file: ${which}.ph") if ( ! -e "$SENSOR_PATH/${which}.ph");
   require "${which}.ph";
#
# The PID file containing the group pid of the last known 'tcpdump' started
# by the SHADOW sensor scripts.
#
   $LOGPID  = "$LOGDIR/$which.pid";
#
# The name of the filter file to have 'tcpdump' apply as it saves packets
#
   $FILTER = "$SENSOR_PATH/$which.filter";

# First, let's see if a prior SHADOW tcpdump process is running. If one is,
# we need to stop it and start it's replacement. The paramter file names
# the file in which the PID is saved, so we are fairly sure we're stopping
# the correct tcpdump process and ignoring any others.
#
#
   if ( -f $LOGPID )
   {
#
# Fetch list of processes running with the saved group pid. Identify the
# pid of the tcpdump process running in that group.
#
      $grpid = `cat $LOGPID`;
      if ( $grpid )
      {
#
# The $LOGPID file exists. See if the SHADOW tcpdump process identified
# in that file is really running. 
#
         @lines = `ps ajx | grep $grpid`; 
         @dmp_line = grep /$LOGPROG/, @lines;
         ($crap, $ppid, $pid, $rest) = split(/\s+/,$dmp_line[0],4);
         if ( $pid )
#
# The $LOGPID files exists, a SHADOW tcpdump process identified by that file
# is running. Stop it and begin another one.
#
         {
            system("$SENSOR_PATH/stop_logger.pl $which");
         }
      }
   }
   system("$SENSOR_PATH/start_logger.pl $which");
}
exit 0;
