#!/bin/sh
#
# sensor_init.sh -   SHADOW release 1.6
#                    Last changed 25 Aug 1999
#
#
# This shell script should be inserted into the /etc/rc.d/init.d directory of
# Redhat Linux, with symbolic links S51sensor in /etc/rc.d/rc3.d and K51sensor
# in /etc/rc.d/rc1.d. Your mileage will vary if not using RedHat.
#
# description: Starts and stops the tcpdump process.

SENSOR_PATH=/usr/local/logger/sensor
SENSOR_PARAMETER=ALL

# Source function library.
. /etc/rc.d/init.d/functions

# Source networking configuration.
. /etc/sysconfig/network

# See how we were called.
case "$1" in
  start|restart)
        echo -n "(Re-)Starting SHADOW sensor: "
        $SENSOR_PATH/sensor_driver.pl $SENSOR_PARAMETER > /dev/null 2>&1
        echo
        ;;
  stop)
        echo -n "Shutting down SHADOW sensor: "
        $SENSOR_PATH/stop_logger.pl $SENSOR_PARAMETER > /dev/null 2>&1
        echo ""
        ;;
  status)
        status tcpdump
        ;;
  *)
        echo "Usage: sensor {start|stop|restart|status}"
        exit 1
esac
