#!/usr/bin/perl
#
# start_logger.pl -  SHADOW release 1.6
#                    Last changed 28 Sep 1999
#
# startup-wrapper for the tcpdump used in the SHADOW tool.
#
# Author: Olav Kolbu <olav.kolbu@usit.uio.no>
# Modifier: Bill Ralph <wralph@nswc.navy.mil>
#
# This code is hereby released into the public domain. It is released
# "as-is". All warranties disclaimed, implied or otherwise.
# 

# These are the external variables we need. This must be in a suitable
# directory.
#
$SENSOR_PATH = "/usr/local/logger/sensor";
unshift(@INC, $SENSOR_PATH);
#
# Added a calling parameter to specify the "variables" header file with
# needed parameter definitions. This easily allows different paths, values,
# and filters for particular situations. It should also allow multiple
# tcpdumps to run on a single machine.
# 
if ($ARGV[0] eq "ALL")
{
   chdir($SENSOR_PATH);
   @instances = <*.ph>;
} else {
   @instances = @ARGV;
}
foreach $instance (@instances)
{
   ($which, $rest) = split(/\./, $instance);
   die ("No such file: ${which}.ph") if ( ! -e "$SENSOR_PATH/${which}.ph");
   require "${which}.ph";
#
# The PID file containing the group pid of the last known 'tcpdump' started
# by the SHADOW sensor scripts.
#
   $LOGPID  = "$LOGDIR/$which.pid";
#
# The name of the filter file to have 'tcpdump' apply as it saves packets
#
   $FILTER = "$SENSOR_PATH/$which.filter";
#
#
#------------------------Cut Here -------------------------------------
#
# The following lines are retained for compatability with previous versions
# of SHADOW. If you are running both the analyzer and sensor at the same
# version (1.6 or later), then the following section is removable.
#
   `cp $LOGDIR/snif.date.1 $LOGDIR/snif.date.2`;
   `cp $LOGDIR/snif.date.0 $LOGDIR/snif.date.1`;
   `cp $LOGDIR/snif.date $LOGDIR/snif.date.0`;
#
   `cp $LOGDIR/sensor.date.1 $LOGDIR/sensor.date.2`;
   `cp $LOGDIR/sensor.date.0 $LOGDIR/sensor.date.1`;
   `cp $LOGDIR/sensor.date $LOGDIR/sensor.date.0`;
#
#------------------------Cut Here -------------------------------------
#
#
# Current date goes into a file for later use
#
   $date2 = strftime("%y%m%d%H $TZ", @T);
   open(DATE, ">$LOGDIR/snif.date");
   print DATE $date2;
   close(DATE);
#
# Do it again with the full 4-digit year.
#
   $date4 = strftime("%Y%m%d%H $TZ", @T);
   open(DATE, ">$LOGDIR/sensor.date");
   print DATE $date4;
   close(DATE);
#
#
# Prepare the parameters to pass to the tcpdump program.
#
   $param =  "$PROGPAR -w - -F $FILTER";
   $param .= " 2>>$LOGDIR/tcpdump.err| $GZIPPROG > $TCPLOG4 2>/dev/null";

#
# Create the file and its link
#
   chdir($LOGDIR);
#
# If the output file already exists, we could have another process running
# and actively writing to the file. The safest thing to do is to abort the
# current start process and ask for intelligent human intervention.
#
   die("Log file $TCPLOG4 already exists, aborting.") if ( -e $TCPLOG4);
   open(OUT, ">$TCPLOG4") or die("Unable to create $TCPLOG4");
   close(OUT);
   unlink($LOG2FILE) if ( -e $LOG2FILE);
   symlink($LOG4FILE, $LOG2FILE);

# Fire up the actual program. 
#
#
   if ($pid = fork) {
#
# Parent code
#
# Wait a couple of seconds for the child to get started.
#
# Set our process group number to the pid of our parent.
# Saves the process group pid in the LOGPID file.
#
      $grppid = $pid;
      sleep 4;

#
#  Parent is done, make the child an orphan.
#
      next;

   } else {
#
# Child code.
#
      $pid = POSIX::getpid();
      setpgrp(0, $pid);
      $grppid = getpgrp(0);
      unlink $LOGPID;
      `echo "$grppid" > $LOGPID`;
      exec("$LOGPROG $param &");
   }
}
exit 0;
