#!/usr/bin/perl
#
# stop_logger.pl -   SHADOW release 1.6
#                    Last changed 18 Nov 1999
#
# shutdown-wrapper for the tcpdump used in the SHADOW tool.
#
# Author: Olav Kolbu <olav.kolbu@usit.uio.no>
# Modifier: Bill Ralph <wralph@nswc.navy.mil>
#
# This code is hereby released into the public domain. It is released
# "as-is". All warranties disclaimed, implied or otherwise.
# 

# These are the external variables we need
#
$SENSOR_PATH = "/usr/local/logger/sensor";
unshift(@INC, $SENSOR_PATH);
#
# Added a calling parameter to specify the "variables" header file with
# needed parameter definitions. This easily allows different paths, values,
# and filters for particular situations. It should also allow multiple
# tcpdumps to run on a single machine.
#
if ($ARGV[0] eq "ALL") 
{
   chdir($SENSOR_PATH);
   @instances = <*.ph>;
} else {
   @instances = @ARGV;
}
foreach $instance (@instances)
{
   ($which, $rest) = split(/\./, $instance);
   die ("No such file: ${which}.ph") if ( ! -e "$SENSOR_PATH/${which}.ph");
   require "${which}.ph";
#  
# The PID file containing the group pid of the last known 'tcpdump' started
# by the SHADOW sensor scripts.
# 
   $LOGPID  = "$LOGDIR/$which.pid";
#
# The name of the filter file to have 'tcpdump' apply as it saves packets
#
   $FILTER = "$SENSOR_PATH/$which.filter";
#

   if ( -f $LOGPID )
   {
#
# Fetch list of processes running with the saved group pid. Identify the
# pid of the tcpdump process running in that group, and signal it to end.
# I suspect that "ps ajx" is non-portable.
#
      $grppid = `cat $LOGPID`;
      do { $cnt = chomp($grppid) } while $cnt;
      @lines = `ps ajx | grep $grppid`; 
      @dmp_line = grep /$LOGPROG/, @lines;
      if (scalar(@dmp_line) == 0) {
         print "$0: process group $grppid not running, aborting.\n";
         unlink $LOGPID;
         next;
      }
      ($crap, $ppid, $pid, $rest) = split(/\s+/,$dmp_line[0],4);
      if ( ! $grppid )
      {
        print "$0: Pid file '$LOGPID' bad or empty, aborting\n";
        unlink $LOGPID;
        next;
      }
      elsif ( kill (0, int($pid)) )
      {
        kill (15, int($pid));    
        sleep(2); # Give the program some time to finish
        if ( kill (0, int($pid)) )
        {
          print "$0: Unable to kill $LOGPROG, aborting\n";
          next;
        }
      }
      else
      {
        print "$0: PID: $pid was not running\n";
        next;
      }
      unlink $LOGPID;
   }
   else
   {
# Here we could have tried to locate the pid using 'ps' but
# we might zap a vital tcpdump run by some BOFH so we abstain.
     print "$0: NO pid file '$LOGPID', exiting\n";
     next; 
   }
}
exit 0;
