#  Variables needed by the analyzer scripts. Tailor this file
#  to define the paths for different sensor sites.
#
# GENERIC.ph         - SHADOW Version 1.6
#                      Last changed 06 January 2000
#
$SHADOW_PATH = "/usr/local/logger";
$ENV{PATH} = "/bin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin:$SHADOW_PATH";
#
use POSIX qw(strftime);
use Time::Local;
#
$SITE="SITE1";
@SITE_IP=("172.16.31", "192.168");
$SENSOR="sensor01.goodguys.com";
$WEB_SERVER="www.goodguys.com";
$SENSOR_DIR="/LOG";
$ANALYZER_DIR="/LOG/$SITE";
$OUTPUT_WEB_DIR="/home/httpd/html/tcpdump_results/$SITE";
$URL_OUTPUT_DIR="/tcpdump_results/$SITE";
$FILTER_DIR="$SHADOW_PATH/filters/$SITE";
$GENERIC_FILTERS="$SHADOW_PATH/filters/generic";
$SCAN_THRESHHOLD = "7";
$LEVEL2_HOST="second.goodguys.com";
$LOG_FILE = "/tmp/${0}";
#
# Set the date for cleanup.pl to 2 days + 15 minutes ago.
#
$CLEAN2_DATE=strftime("%y%m%d", localtime(time-2*24*60*60-15*60));
$CLEAN4_DATE=strftime("%Y%m%d", localtime(time-2*24*60*60-15*60));
