#!/usr/bin/perl -w
#
# sort_and_resolve.pl    - SHADOW Version 1.6
#                          Last changed 21 Sep 1999
#
#
# Originally written by Vicki Irwin,
# "One of the nation's top intrusion detection analysts."
# formerly of the Naval Surface Warfare Center.
#
# Modified by Bill Ralph
#
# Aug 20 1998 - Consolidated sort_by* and resolve_* so they wouldn't take
# so long.
#
# Apr 5, 1999 - Added secondary sort by time to sub by_IP
#
#must input argument of file to sort
#This file operates on files written by one of the scanning programs 
#and orders entries by source IP, date, and time. 

use Socket;

sub by_IP
{
    @fieldsa = split(/\s+/ , $a);
    @fieldsb = split(/\s+/ , $b);
    @avec = split(/\./ , $fieldsa[1]);
    @bvec = split(/\./ , $fieldsb[1]);

    $avec[0] <=> $bvec[0]
        or
    $avec[1] <=> $bvec[1]
        or
    $avec[2] <=> $bvec[2]
        or
    $avec[3] <=> $bvec[3]
        or
    $fieldsa[0] cmp $fieldsb[0]
}

sub resolve
{
#
# Given an IP address: xxx.xxx.xxx.xxx, return a machine name if it exists.
#

   my $param = shift(@_);
   my @octets = (0) x 4;
   @octets = split(/\./, $param);
   my $ip_addr = "$octets[0].$octets[1].$octets[2].$octets[3]";
   
     
   if ($ip_name{$ip_addr}) {
      $name = $ip_name{$ip_addr};
   } elsif (($octets[3] == 0) or ($octets[0] == 255) or 
          ($octets[1] == 255) or ($octets[2] == 255) or 
          ($octets[3] == 255)) {
          $name = $ip_addr;
          $ip_name{$ip_addr} = $ip_addr;
   } else {
#
# call system to fetch hostname
#   
      my $binip = pack "c4",$octets[0],$octets[1],$octets[2],$octets[3];
      my @info = gethostbyaddr($binip,AF_INET);
      $name = $info[0] ? $info[0] : $ip_addr;
     
      $ip_name{$ip_addr} = $name;
   }
   return $name;

}
#
# Main Program, Initialize Name/IP hash.
#
%ip_name = ();
$filein = $ARGV[0];
open(IN,"$filein");

@all = <IN>;

close(IN);

@IPsorted = sort by_IP @all;

$filenameout = $filein . ".sorted";

$oldsrcip = "0.0.0.0";
$olddataline = "gobbledeegook";
open(OUT,">$filenameout");
foreach $dataline (@IPsorted)
{
    @fields = split(/\s+/,$dataline);

    @srcoctets = split(/\./,$fields[1]);
    $srcip = "$srcoctets[0].$srcoctets[1].$srcoctets[2].$srcoctets[3]";
    $srcname = resolve($srcip);

    @dstoctets = split(/\./,$fields[3]);
    $dstoctets[3] =~ tr/://d;
    $dstip = "$dstoctets[0].$dstoctets[1].$dstoctets[2].$dstoctets[3]";
    $dstname = resolve($dstip);
    
    if ($srcip eq $oldsrcip)
    {
       if ($dataline ne $olddataline)
       {
           $dataline =~ s/$srcip/$srcname/ if ($srcname);
           $dataline =~ s/$dstip/$dstname/ if ($dstname);
           print OUT $dataline;
	   $olddataline = $dataline;
       }
    }
    else
    {
       print OUT "\n";
       if ($srcname) {
          print OUT "$srcip > $dstip\n";
          $dataline =~ s/$srcip/$srcname/;
       }
       $dataline =~ s/$dstip/$dstname/ if ($dstname);
       print OUT $dataline;
       $oldsrcip = $srcip;
       $olddataline = $dataline;
    }
}
close(OUT);

print "Result is in file ",$filenameout," \n";


