#!/usr/bin/perl
#
# strip.pl           - SHADOW Version 1.6
#                      Last changed 21 Sep 1999
#
# Read a file and remove the comments (everything after a #) and blank lines.
# 
# Comment your tcpdump filter files to document what each line of the filter is
# intended to catch. 
#
# Then run strip.pl < {documented_filter_file} > {filter_file}
#
# Written by Bill Ralph - 10/20/98
#
#
sub usage {
        print "Usage: strip.pl FILE_NAME\n";
        exit 2;
}
#
sub remove_blanks {
#
# Remove blank lines.
#
   my $chr = substr($_, -1, 1);
   while (($chr eq " ") or ($chr eq "\t") or ($chr eq "\n")) {
      chop($_);
      $chr = substr($_, -1, 1);
   } 
   return;
}
#
#       Parse the parameters.
#
#
#  Check parameter validity.
#
$file = $ARGV[0];
if ("$file" eq "")
{
        usage();
}
#
#
open(ANO, "<$file") or die("Unable to open file $file.");
while (<ANO>) {
#
# Remove totally blank lines.
#
   remove_blanks();
   next unless (length($_) > 0);
#
# Find the comment Character. Remove everything after it. Remove the
# whole line if the comment character is in column 1.
#
   $com = index($_, "#");
   if ($com == -1) {
      print STDOUT $_, "\n";
   } elsif ($com == 0) {
      next;
   } else {
      $_ = substr($_, 0, $com);
      remove_blanks();
      print STDOUT substr($_, 0, $com), "\n" if (length($_) > 0);
   }
}
close(ANO);
