# Version of tcpdump/libpcap
%define tversion 3.6.2
%define pversion 0.6.2
Summary: A network traffic monitoring tool.
Name: tcpdump
Version: 3.6.2
%define	tcpdump_dir	tcpdump-3.6.2
Release: wdr2
Copyright: BSD
Group: Applications/Internet
Source0: http://www.tcpdump.org/release/tcpdump-%{tversion}.tar.gz
Source1: http://www.tcpdump.org/release/libpcap-%{pversion}.tar.gz
Patch01:tcpdump-3.6.2-wdr2.patch
#
Prefix: %{_prefix}
BuildRoot: /tmp/%{name}-root
BuildRequires: kernel-headers >= 2.2.0
Requires: kernel >= 2.2.0

%description
Tcpdump is a command-line tool for monitoring network traffic.
Tcpdump can capture and display the packet headers on a particular
network interface or on all interfaces.  Tcpdump can display all of
the packet headers, or just the ones that match particular criteria.

Install tcpdump if you need a program to monitor network traffic.

%package -n libpcap
Version: 0.6.2
%define	libpcap_dir	libpcap-0.6.2
Summary: A system-independent interface for user-level packet capture.
Group: Development/Libraries
Requires: kernel >= 2.2.0

%description -n libpcap
Libpcap provides a portable framework for low-level network
monitoring.  Libpcap can provide network statistics collection,
security monitoring and network debugging.  Since almost every system
vendor provides a different interface for packet capture, the libpcap
authors created this system-independent API to ease in porting and to
alleviate the need for several system-dependent packet capture modules
in each application.

Install libpcap if you need to do low-level network traffic monitoring
on your network.

%prep
%setup -q -c -a 1

cd %libpcap_dir
cd ..

cd %tcpdump_dir
%patch01 -p1
cd ..

%build
cd %libpcap_dir
#libtoolize --copy --force
#CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=/usr --mandir=/usr/share/man

%configure

make

cd ..

cd %tcpdump_dir
#libtoolize --copy --force
#CFLAGS="$RPM_OPT_FLAGS -DIP_MAX_MEMBERSHIPS=20" ./configure --prefix=/usr

%define	optflags $RPM_OPT_FLAGS -DIP_MAX_MEMBERSHIPS=20
autoconf
%configure
%undefine optflags

make

cd ..

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p ${RPM_BUILD_ROOT}%{_prefix}/{include/net,lib,share/man/man3,share/man/man8,sbin}

cd %libpcap_dir
make DESTDIR=$RPM_BUILD_ROOT install
cd ..

cd %tcpdump_dir
make DESTDIR=$RPM_BUILD_ROOT install
cd ..

( cd $RPM_BUILD_ROOT
  strip .%{_prefix}/sbin/* || :
)

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc	%tcpdump_dir/README %tcpdump_dir/CHANGES %tcpdump_dir/CREDITS
%doc	%tcpdump_dir/FILES %tcpdump_dir/INSTALL %tcpdump_dir/LICENSE
%doc	%tcpdump_dir/PLATFORMS %tcpdump_dir/VERSION %tcpdump_dir/TODO
%{_prefix}/sbin/tcpdump
%{_prefix}/share/man/man1/tcpdump.1*

%files -n libpcap
%defattr(-,root,root)
%doc	%libpcap_dir/README %libpcap_dir/CHANGES %libpcap_dir/CREDITS
%doc    %libpcap_dir/FILES %libpcap_dir/INSTALL %libpcap_dir/README.linux
%doc	%libpcap_dir/VERSION %libpcap_dir/LICENSE
%{_prefix}/include/pcap.h
%{_prefix}/include/pcap-namedb.h
%{_prefix}/include/net/bpf.h
%{_prefix}/lib/libpcap.a
%{_prefix}/share/man/man3/pcap.3*

%changelog
* Wed Apr 18 2001 Bill Ralph <wralph@nswc.navy.mil>
- Updated to release 3.6.2 of tcpdump and release 0.6.1 of libpcap.

* Wed Jan 17 2001 Bill Ralph <wralph@nswc.navy.mil>
- Updated to release 3.6.1 of tcpdump and 0.6.1

* Thu Jul 20 2000 Bill Ralph <wralph@nswc.navy.mil>
- Stole SPEC from RedHat.
- Rework for release of tcpdump-3.5 and libcap-0.5
- Remove arpwatch
