#!/usr/bin/perl
#
# cleanup.pl         - SHADOW Version 1.7
#                      Last changed 21 May 2001
#
#  Script to clean up the directory on the SENSOR to prevent loss of data 
#  due to a disk partition filling up. 
#  This script will be run by cron nightly.
#  
#  Written by Bill Ralph <RalphWD@nswc.navy.mil>
#
# Set up some variables.
#
use Getopt::Long;
use POSIX qw(strftime);
#
do '/usr/local/etc/SHADOW.conf' or
   die("Unable to find SHADOW config file /usr/local/etc/SHADOW.conf");
#
sub usage {
        print "Usage: cleanup.pl [-debug] -d YYYYMMDD -l Site.\n";
        exit 2;
}
#
#	Parse the parameters.
#
&GetOptions("debug", \$debug, "d:s", \$clean_date, "l=s", \$Site);
$date_len = length($clean_date);
#
# Parse the $clean_date  into its subcomponents.
#
if ($clean_date) {
#
# Play with the $clean_date parameter so we understand what's happening.
#
   exit 2 if ($date_len < 8);
   $yr_format =  "a4a2a2a2";
   ($year, $mon, $mday) = unpack($yr_format, $clean_date);
   $mon -= 1;
   $subdir = strftime("%b%d", 0, 0, 0, $mday, $mon, $year, 0, 0, 0);
}
##
#
#  Rid ourselves of standard output and error to prevent tons of mail messages
#  from cron.
#
@lvls = split(/\//,$0);				# Split path
($call, $suf) = split(/\./, $lvls[$#lvls]);	# Split call.suffix
$LOG_FILE = $debug ? "/tmp/$call.log" : "/dev/null";
open(STDOUT, ">>$LOG_FILE");
select STDOUT; $| = 1;
open(STDERR, ">&STDOUT");
select STDERR; $| = 1;              # make unbuffered
#
# Writer a marker to the log file.
#
$marker=strftime("%c", localtime(time));
chomp $marker;
print STDOUT $marker;
foreach $param ($0, @ARGV) {
   printf " %s", $param;
}
print STDOUT "\n";
#

   print STDOUT "Command line: d = $clean_date \n";
   print STDOUT "Command line: l = $Site \n";

#  
#
# Once the Site is identified from the command line,
# load the needed external Parameters.
#
unshift(@INC, "$SHADOW_PATH/sites");
require "${Site}.ph";

#
# If the $clean_date is specified in the call, use it, otherwise
# use the default specified in the site-specific .ph file.
#
@def_clean_time = localtime(time - $CLEAN_TIME*24*60*60-15*60);
$def_clean_date = strftime("%Y%m%d", @def_clean_time);
$clean_date = $def_clean_date unless ($clean_date);
print STDOUT "clean_date = $clean_date\n";

#
#
# Remove the files matching our clean_date
#
$file_pat = "$SENSOR_DIR/tcp.$clean_date??.gz";
$cmd="df $SENSOR_DIR;rm $file_pat;df $SENSOR_DIR";
$cmd='"' . $cmd . '"';

print STDOUT "Removing $file_pat from $SENSOR.\n";
print STDOUT ("$SSH_CMD -l root $SENSOR $cmd\n");

$ssh_cmd = "$SSH_CMD -l root $SENSOR $cmd";
open (CMD, "$ssh_cmd|");
while (<CMD>) {
   print STDOUT $_;
}
close(CMD);

print STDOUT "cleanup.pl completed for clean_date: $clean_date\n";
#
