#! /usr/bin/perl
#
# find_scan.pl         - SHADOW Version 1.7
#                        Last changed 12 July 2001
#
# Written by Bill Ralph <RalphWD@nswc.navy.mil>.
#
#  This program requires two command line arguments:
#  The first is the name of the file into which the sorted output will
#  be written after running the filter.getall filter.
#
$output_filename = $ARGV[0];
$threshhold = $ARGV[1] ? $ARGV[1] : 10;
#
print STDERR "Begin find_scan.pl \n";

$pkt_number = 0;
while(<STDIN>) 
{
   $pkt_number++;
   next if /gre-proto/;
   next if /trunc/;
   ($src_ip, $crap1, $dst_ip, $flags, $crap2) = split(/\s+/, $_, 5);

   $src_port = "";
   if (split(/\./, $src_ip) == 5) {
      $src_port = pop(@_);
      $src_ip = join('.', @_);
   }

   $dst_ip =~ tr/://d;
   if ($flags eq "icmp:") {
      $dst_port = "ICMP";
   } else {
      $dst_port = "";
   }
   if (split(/\./, $dst_ip) == 5) {;
      $dst_port = pop(@_);
      $dst_ip = join('.', @_);
   }
#
   $src_dsthash{$src_ip}{$dst_ip}{$dst_port}++;
   $src_porthash{$src_ip}{$dst_port}++;
#  if ($pkt_number%10000 == 0) {
#     printf STDERR "Packet number %-10i processed....\r", $pkt_number;
#  }
}

close(INPUT);

#print STDERR "Analyzing output....\n";

foreach $src_ip (keys(%src_dsthash))
{
   $num_hits = 0;
   $num_port = scalar(keys(%{ $src_porthash{$src_ip} } ));
   $num_port2 = scalar(keys(%{ $src_dsthash{$src_ip} } ));
   $num_sys = scalar(keys(%{ $src_dsthash{$src_ip} }));
   foreach $dst_ip (keys(%{ $src_dsthash{$src_ip} })) {
      foreach $dst_port (keys(%{ $src_dsthash{$src_ip}{$dst_ip} } )) {
         $num_hits += $src_dsthash{$src_ip}{$dst_ip}{$dst_port};
      }
   }
   if (($num_sys > $threshhold) || ($num_port > 10*$threshhold)) {
#  if (($num_sys > $threshhold) || 
#      (($num_port > 100) && ($num_hits > 1000))) {
      $tgt_sys{$src_ip} = $num_sys;
      $tgt_port{$src_ip} = $num_port;
      $tgt_hits{$src_ip} = $num_hits;
   }
}

#print STDERR "Writing output file .....\n";

open (OUT,">$output_filename");

printf(OUT "%-7s %-7s %-7s %-17s %-50s \n\n",
        "#IPs", "ports", "pkts", "src", "name");

foreach $src_ip (sort by_ip keys(%tgt_sys))
{
   @srcoctets = split(/\./, $src_ip);
   $binip = pack "c4",$srcoctets[0],$srcoctets[1],$srcoctets[2],$srcoctets[3];
   @info = gethostbyaddr($binip,2);
   $srcname = $info[0];

   printf(OUT "%-7d %-7d %-7d %-17s %-40s \n",
     $tgt_sys{$src_ip}, $tgt_port{$src_ip}, $tgt_hits{$src_ip},
     $src_ip, $srcname);
}
close(OUT);

print STDERR "End find_scan.pl.\n";

#########################################################################
#
sub by_ip
{
   @avec = split(/\./ , $a);
   @bvec = split(/\./ , $b);

   $avec[0] <=> $bvec[0]
       or
   $avec[1] <=> $bvec[1]
       or
   $avec[2] <=> $bvec[2]
       or
   $avec[3] <=> $bvec[3]
}

