#!/usr/bin/perl
#
# compose_IR.cgi         - SHADOW Release 1.7
#                          Last Changed 11 Jul 2001
#
# Written by:              Bill Ralph
#                          <RalphWD@nswc.navy.mil>
#
use CGI qw/:all/;
use CGI::Carp qw(fatalsToBrowser);
use POSIX;
use Time::Local;
#
do "/usr/local/etc/SHADOW.conf" ||
   die("Unable to load SHADOW configuration file: /etc/SHADOW.conf.");
#
# Use /tmp/IR_seq for sequence number if testing the script.
#
#$IR_SEQNO_FILE = "/tmp/IR_seq";
#$IR_DATA_FILE = "/tmp/Incident-Reports";
$IR_SEQNO_FILE = $SHADOW_IR_SEQNO_FILE;
$IR_DATA_FILE = $SHADOW_IR_DATA_FILE;
#
# Define some "constants" for the file locking calls.
#
   $LOCK_SH = 1;
   $LOCK_EX = 2;
   $LOCK_NB = 4;
   $LOCK_UN = 8;
   
#
sub fetch_seqno
{
# Read a file for an IR sequence number for todays date. Do not modify the 
# file at this point. That will be done when the form is submitted.
#
# Written by Bill Ralph - 25 Jan 1999
#
#
# Calculate the IR sequence number from todays date.
#
   $todays_date = strftime("%Y%m%d", localtime);
   $todays_prefix = "GGI-IDR${todays_date}";
   $todays_seq = "001";
   if (open(SEQ_FILE, "<${IR_SEQNO_FILE}")) {
      my $line = <SEQ_FILE>;
      (my $prefix, my $seq) = split(/\./,$line);
      if ($prefix eq $todays_prefix) {
         $todays_seq = sprintf("%03d", ++$seq);
      }
   }
   my $new_seqno = "${todays_prefix}.${todays_seq}";
   return $new_seqno;
}
#
sub update_seqno
{
# Read a file for an IR sequence number for todays date. If it exists, 
# increment and resave it. If not create the file, create the seq no, and 
# save it.
#
# Written by Bill Ralph - 12/29/98
#
#
# Calculate the IR sequence number from todays date.
#
   $todays_date = strftime("%Y%m%d", localtime);
   $todays_prefix = "GGI-IDR${todays_date}";
   $todays_seq = "001";
   $new_seqno = "${todays_prefix}.${todays_seq}";
   if (-s ${IR_SEQNO_FILE}) {
      open(SEQ_FILE, "+<${IR_SEQNO_FILE}")
          or die("Unable to open IR Sequence file");
      flock(SEQ_FILE, $LOCK_EX);
      my $line = <SEQ_FILE>;
      (my $prefix, my $seq) = split(/\./,$line);
      if ($prefix eq $todays_prefix) {
         $todays_seq = sprintf("%03d", ++$seq);
      }
      $new_seqno = "${todays_prefix}.${todays_seq}";
      seek(SEQ_FILE, 0, 0);
      print SEQ_FILE "$new_seqno\n";
      close(SEQ_FILE);
      flock(SEQ_FILE, $LOCK_UN);
   } else {
      open(SEQ_FILE, ">${IR_SEQNO_FILE}")
          or die("Unable to create IR Sequence file");
      $new_seqno = "${todays_prefix}.${todays_seq}";
      print SEQ_FILE "$new_seqno\n";
      close(SEQ_FILE);
   }
   return $new_seqno;
}
#
#
#
$today = strftime("%a %b %d, %Y - %T", localtime(time));
print header,
start_html(-title=>'Create an Incident Report',
           -author=>'RalphWD@nswc.navy.mil',
           -bgcolor=>'#D2FFD2',
          );
if (!param) {
   $shadow_seqno = fetch_seqno();
   print start_form(-target=>'_self'),
   h3({-align=>CENTER}, "GoodGuys Industries - Network Detection Report"),
   "GoodGuys Report No.: ",
   textfield(-name=>'rep_num',
             -size=>26,
             -value=>$shadow_seqno),
   p(),
   "Actual Addresses Mail Recipients: ",
   textfield(-name=>'raw_mailto',
             -size=>30,
             -value=>'Raw_IRs'),
   p(),
   "Obfuscated Addresses Mail Recipients: ",
   textfield(-name=>'obf_mailto',
             -size=>30,
             -value=>'Obf_IRs'),
   p(),
   ol({-type=>"1"},
      li("Report Date: $today"), 
      p(),
      li("Incident Date: "),
      textfield(-name=>'inci_date',
                -size=>20),
      p(),
      li("Type of Incident: "),
      scrolling_list(-name=>'inci_type',
                     -size=>1,
                     -values=>[
                            'Denial of Service Attempt', 
                            'IMAP Connection Attempt', 
                            'Remote Login Attempt', 
                            'RESET Scan', 
                            'SYN/RST Scan', 
                            'FTP Scan',
                            'Port Scan', 
                            'POP3 Scan', 
                            'SNMP Probe/Scan', 
                            'RPC/Portmap Connection Attempt',
                            'DNS Zone Transfer Attempt', 
                            'Single System Connection Attempt', 
                            'SOCKS Exploit', 
                            'Informational Report',
                            'Multiple Target/Port Scan or Connection Attempts', 
                            'Network Mapping Attempt', 
                            'Unknown Probe type',
                            'ICMP Scan', 
                            'DNS Scan', 
                            'NETBIOS Scan',
                            'Unknown UDP Event', 
                            'Unknown ICMP Event', 
                            'Unknown TCP Event', 
                            'Possible IP Spoofing Event', 
                              ],
                     -default=>'Informational Report'),
      p(),
      li("Subjects Involved: "),
      p(),
      ol({-type=>"a"},
         li("Source: "),
         textfield(-name=>'inci_source', -size=>35),
         p(),
         li("Target(s): "),
         textfield(-name=>'inci_target', -size=>50,
                -value=>"GoodGuys Industries Incorporated - Podunk HQ"),
      ),
      p(),
      li("Location of Detector: "), 
      scrolling_list(-name=>'detector',
                     -size=>1,
                     -values=>[
                        'Inside Facility Firewall',
                        'Inside Facility Perimeter, Outside Firewall', 
                        'Outside Facility Firewall, Outside Perimeter'
                      ], 
                     -default=>'Inside Facility Firewall'),
      p(),
      li("Cost of this Incident: "),
      textfield(-name=>'inci_cost',
                -size=>20,
                -value=>'No Downtime.'),
      p(),
      li("Summary of Incident and Investigation Results: "),
      p(),
      textarea(-name=>'summary',
               -rows=>10,
               -cols=>80,
               -wrap=>'physical'),
   ),
   p(),
   submit(-name=>'IR', -value=>'Send It'),
   end_form;
} else {
   $raw_recipients = param('raw_mailto');
   $obf_recipients = param('obf_mailto');
#
# Comment out the following statement if testing this script.
#
   $rep_num = update_seqno();
   $inci_date = param('inci_date');
   $inci_type = param('inci_type');
   $detector = param('detector');
   $inci_source = param('inci_source');
   $inci_target = param('inci_target');
   $mail_subject = "$rep_num  : ${src_txt}${inci_type} \@ GoodGuys.com";
   $inci_cost = param('inci_cost');
   $inci_summ = param('summary');
   $inci_summ =~ tr/\r//d;
   $raw_mail_cmd = "/usr/sbin/sendmail -t -oi";
   $obf_mail_cmd = "/usr/sbin/sendmail -t -oi";
#  $raw_mail_cmd = "cat > /tmp/raw_mail_$$";
#  $obf_mail_cmd = "cat > /tmp/obf_mail_$$";
#
# Create an array of lines of our mail message.
#
   @lines = split(/\n/, <<"EOF" );
Subject: $mail_subject

                  GoodGuys Industries - Network Security Division
                            Network Detection Report

                               Phone 000-555-1212

GGII Intrusion Detection Report No.: $rep_num

   1. Report Date: $today
   2. Incident Date: $inci_date
   3. Type of Incident: $inci_type
   4. Subjects Involved: 
         a. ${src_txt}Source: $inci_source
         b. Target(s): $inci_target
   5. Location of Detector: $detector
   6. Cost of this Incident: $inci_cost
   7. Summary of Incident and Investigation Results: 

$inci_summ

***** End of GGI Intrusion Detection Report No.: $rep_num *****
EOF
#
# Create a temporary file and obfuscate the addresses for this report.
#
   do { 
      $temp_file = tmpnam(); 
   } until sysopen (TEMP, $temp_file, O_CREAT|O_EXCL|O_RDWR, 0666);
   foreach $line (@lines) {
      print TEMP "$line\n";
   }
   close(TEMP);
   $obf_cmd = "$SHADOW_PATH/obfuscate.pl $temp_file";
#
   open(OBFUSCATE, "$obf_cmd |");
   while (<OBFUSCATE>) {
      chomp($_);
      push(@obf_lines, $_);
   }
   close(OBFUSCATE);
   unlink("$temp_file");
#
# Insert the "To:" line for the raw and obfuscated mail arrays.
#
   unshift(@lines, "From: The GoodGuys SHADOW Team <shadow\@goodguys.com>");
   unshift(@lines, "To: $raw_recipients");
   unshift(@obf_lines, "From: The GoodGuys SHADOW Team <shadow\@goodguys.com>");
   unshift(@obf_lines, "To: $obf_recipients");
#
# Copy the array of uncensored lines to the sendmail command and the 
# database of Incident Reports we're saving.
#
   open(IRDATA, ">>$IR_DATA_FILE");
#
# Make sure we have exclusive access to the data file.
#
   flock(IRDATA, $LOCK_EX);
   print IRDATA "Obfuscated To: $obf_lines[0]\nUncensored ";
   foreach $line (@lines) {
      print IRDATA "$line\n";
   }
   close(IRDATA);
   flock(IRDATA, $LOCK_UN);
#
   if ($obf_recipients) {
      open(MAILCMD, "|$obf_mail_cmd");
      foreach $line (@obf_lines) {
         print MAILCMD "$line\n";
      }
      close(MAILCMD);
   }
#
   if ($raw_recipients) {
      open(MAILCMD, "|$raw_mail_cmd");
      foreach $line (@lines) {
         print MAILCMD "$line\n";
      }
      close(MAILCMD);
   };
#
   $mail_contents = join("\n", @obf_lines);
#
# print the web page to show user the mail was sent.
#
   print 
         a({-name=>'print', -href=>'javascript:window.print()'},
         img({-align=>'right',-src=>'/images/print.png',-border=>'0'})),
         h3({-align=>CENTER},"GoodGuys Industries - Network Security Division"),
         h3({-align=>CENTER}," Intrusion Detection Report"), 
         p(),
         hr(),
         center(strong("Phone 000-555-1212")), 
         p(),
         center(strong("GGII Intrusion Detection Report No.:")," $rep_num"), 
         p(),
         p(),
         strong("Sent To: $raw_recipients / $obf_recipients"),
         p(),
         strong("Mail Subject: $mail_subject"),
         hr(),
         p(),
         ol({-type=>"1"},
            li(strong("Report Date: "), "$today"), p(),
            li(strong("Incident Date: "), "$inci_date"), p(),
            li(strong("Type of Incident: "), "$inci_type"), p(),
            li(strong("Subjects Involved: ")), 
            ol({-type=>"a"},
               li(strong("${src_txt}Source:"), "$inci_source"), 
               li(strong("Target(s): "), "$inci_target"), 
            ),
            p(),
            li(strong("Location of Detector: "), "$detector"),
            p(),
            li(strong("Cost of this Incident: "),"$inci_cost"), p(),
            p(),
            li(strong("Summary of Incident and Investigation Results: ")), p(),
            p(),
            pre("$inci_summ"), p(),
         ),
         hr(),
         h3({-align=>CENTER}, "Obfuscated Version:"),
         p(), pre($mail_contents), p(),
         h3({-align=>CENTER}," Mail sent.");
}
print end_html;
