#!/usr/bin/perl
#
# search.cgi              - SHADOW Release 1.7
#                           Last Changed 23 Jul 2001
#
use CGI qw/:standard/;
use CGI::Carp qw(fatalsToBrowser);
use POSIX qw(strftime);
use Time::Local;
use IO::Handle;
#
do "/usr/local/etc/SHADOW.conf" ||
   die("Unable to load SHADOW configuration file: /etc/SHADOW.conf.");
#
%month_no = (
   "Jan" => 0, "Feb" => 1, "Mar" => 2, "Apr" => 3, "May" => 4, "Jun" => 5,
   "Jul" => 6, "Aug" => 7, "Sep" => 8, "Oct" => 9, "Nov" => 10, "Dec" => 11);
#
$multi_day = 1;
$heading =  "Search for a pattern in SHADOW logs.";
$time_now = time;
@today = localtime($time_now);
$today_mday = strftime("%d", @today);
$beg_day = $today_mday;
$end_day = $today_mday;
$today_month = strftime("%h", @today);
$beg_month = $today_month;
$end_month = $today_month;
$today_year = strftime("%Y", @today);
$beg_year = $today_year;
$end_year = $today_year;
#
# Global variables: Define the fields of the form and their characteristics.
#
@parameters = (
               'site', 'nslookup', 'beg_year', 'beg_month', 'beg_day',
               'end_year', 'end_month', 'end_day', 'beg_hour', 'end_hour',
               'hostname', 'host_mod', 'port_join', 'port_num', 'port_mod', 
               'net_join', 'netname', 'net_mod', 'gen_join', 'gen_pat'
              );
#
$param_label = 0;
$max_field_size = 1;
$validity_string = 2;
$default_value = 3;
$labels = 4;
#
%param_info = (
               site=> {
                       param_label => "Which sensor: ", 
                       max_field_size => "8", 
                       param_type => "list",
                       values =>["Sensor1", "Sensor2", "Sensor3"], 
                       labels => {
                         "Sensor1" => "Outside Site Perimeter",
                         "Sensor2" => "Inside Perimeter, Outside Site Firewall",
                         "Sensor3" => "Inside Site Firewall"  ,
                                 },
                       default_value => "Sensor1"
                      },
               nslookup => {
                       param_label => "Host Name Lookup: ",
                       max_field_size => "3",
                       param_type => "list",
                       values => ["Yes", "No"],
                       default_value => "No",
                      },
               beg_year => {
                       param_label => "Start Search - Year: ",
                       max_field_size => "4",
                       param_type => "list",
                       values => ["1998", "1999", "2000", "2001", "2002"],
                       default_value => $today_year,
                      },
               beg_month => {
                       param_label => "Month: ",
                       max_field_size => "3",
                       param_type => "list",
                       values => ["Jan", "Feb", "Mar", "Apr", "May", "Jun",
                                  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                       default_value => $today_month,
                      },
               beg_day => {
                       param_label => "Day of Month: ",
                       max_field_size => "2",
                       param_type => "list",
                       values => ["01", "02", "03", "04", "05", "06", "07",
                                  "08", "09", "10", "11", "12", "13", "14",
                                  "15", "16", "17", "18", "19", "20", "21",
                                  "22", "23", "24", "25", "26", "27", "28",
                                  "29", "30", "31", 
                                 ],
                       default_value => $today_mday,
                      },
               end_year => {
                       param_label => "End Search - Year: ",
                       max_field_size => "4",
                       param_type => "list",
                       values => ["1998", "1999", "2000", "2001", "2002"],
                       default_value => $today_year,
                      },
               end_month => {
                       param_label => "Month: ",
                       max_field_size => "3",
                       param_type => "list",
                       values => ["Jan", "Feb", "Mar", "Apr", "May", "Jun",
                                  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                       default_value => $today_month,
                      },
               end_day => {
                       param_label => "Day of Month: ",
                       max_field_size => "2",
                       param_type => "list",
                       values => ["01", "02", "03", "04", "05", "06", "07",
                                  "08", "09", "10", "11", "12", "13", "14",
                                  "15", "16", "17", "18", "19", "20", "21",
                                  "22", "23", "24", "25", "26", "27", "28",
                                  "29", "30", "31", 
                                 ],
                       default_value => $today_mday,
                      },
               beg_hour => {
                       param_label => "Beginning Hour: ",
                       max_field_size => "2",
                       param_type => "list",
                       values =>   ['00', '01', '02', '03', '04', '05', '06',
                                    '07', '08', '09', '10', '11', '12', '13',
                                    '14', '15', '16', '17', '18', '19', '20',
                                    '21', '22', '23'],
                       default_value => '00',
                       },
               end_hour => {
                       param_label => "Ending Hour: ",
                       max_field_size => "2",
                       param_type => "list",
                       values =>   ['00', '01', '02', '03', '04', '05', '06',
                                    '07', '08', '09', '10', '11', '12', '13',
                                    '14', '15', '16', '17', '18', '19', '20',
                                    '21', '22', '23'],
                       default_value => '23',
                       },
               hostname => {
                        param_label => "Search for a specific IP or host: ",
                        max_field_size => "30",
                        param_type => "string",
                        validity_string => "A-Za-z0-9()_.",
                      },
               host_mod => {
                        param_label => "Host modifier",
                        max_field_size => "6",
                        param_type => "list",
                        values => [ "src", "dst", "either" ],
                        default_value => "either",
                       },
               port_join => {
                        param_label => "Port conjunction",
                        max_field_size => "3",
                        param_type => "list",
                        values => [ "and", "or" ],
                        default_value => "or",
                       },
               port_num => {
                        param_label => " Search for a specific port: ",
                        max_field_size => "5",
                        param_type => "number",
                        min_value => "0",
                        max_value => "65535",
                        default_value => "",
                       },
               port_mod => {
                        param_label => "Port modifier",
                        max_field_size => "6",
                        param_type => "list",
                        values => [ "src", "dst", "either" ],
                        default_value => "either",
                       },
               net_join => {
                        param_label => "Net conjunction",
                        max_field_size => "3",
                        param_type => "list",
                        values => [ "and", "or" ],
                        default_value => "or",
                       },
               netname => {
                        param_label => " Search for a specific IP or net: ",
                        max_field_size => "30",
                        param_type => "string",
                        validity_string => "A-Za-z0-9()_.",
                       },
               net_mod => {
                        param_label => "Net modifier",
                        max_field_size => "6",
                        param_type => "list",
                        values => [ "src", "dst", "either" ],
                        default_value => "either",
                       },
               gen_join => {
                        param_label => "General conjunction",
                        max_field_size => "3",
                        param_type => "list",
                        values => [ "and", "or" ],
                        default_value => "or",
                       },
               gen_pat => {
                        param_label=>" Search with a general TCPDUMP filter: ",
                        max_field_size => "50",
                        param_type => "string",
                        validity_string => "A-Za-z0-9()\-_ ,.;:$[]<>=\!&",
                       },
              );
#
# Subroutine to print fill out form.
#
sub print_form {
   print h1({-align=>CENTER}, $heading),
   start_form(-target=>'_self'),
   submit(-name=>'Action', -label=>'Search'),
   p(),
   $param_info{site}{param_label}, 
   popup_menu(-name=>'site',
               -values=>$param_info{site}{values},
               -labels=>$param_info{site}->{labels},
               -default=>$param_info{site}{default_value}),
   $param_info{nslookup}{param_label}, 
   radio_group(-name=>'nslookup',
               -values=>$param_info{nslookup}{values},
               -default=>$param_info{nslookup}{default_value});
   if ($multi_day) {
      print p(),
      $param_info{beg_year}{param_label},
      popup_menu(-name=>'beg_year',
                 -values=>$param_info{beg_year}{values},
                 -default=>$param_info{beg_year}{default_value}),
      $param_info{beg_month}{param_label},
      popup_menu(-name=>'beg_month',
                 -values=>$param_info{beg_month}{values},
                 -default=>$param_info{beg_month}{default_value}),
      $param_info{beg_day}{param_label},
      popup_menu(-name=>'beg_day',
                 -values=>$param_info{beg_day}{values},
                 -default=>$param_info{beg_day}{default_value}),
      $param_info{beg_hour}{param_label},
      popup_menu(-name=>'beg_hour',
                 -values=>$param_info{beg_hour}{values},
                 -default=>$param_info{beg_hour}{default_value}),
      p(),
      $param_info{end_year}{param_label},
      popup_menu(-name=>'end_year',
                 -values=>$param_info{end_year}{values},
                 -default=>$param_info{end_year}{default_value}),
      $param_info{end_month}{param_label},
      popup_menu(-name=>'end_month',
                 -values=>$param_info{end_month}{values},
                 -default=>$param_info{end_month}{default_value}),
      $param_info{end_day}{param_label},
      popup_menu(-name=>'end_day',
                 -values=>$param_info{end_day}{values},
                 -default=>$param_info{end_day}{default_value}),
      $param_info{end_hour}{param_label},
      popup_menu(-name=>'end_hour',
                 -values=>$param_info{end_hour}{values},
                 -default=>$param_info{end_hour}{default_value});
   } else {
      print p(), "Year: ",
      popup_menu(-name=>'beg_year',
                 -values=>$param_info{beg_year}{values},
                 -default=>$param_info{beg_year}{default_value}),
      $param_info{beg_month}{param_label},
      popup_menu(-name=>'beg_month',
                 -values=>$param_info{beg_month}{values},
                 -default=>$param_info{beg_month}{default_value}),
      $param_info{beg_day}{param_label},
      popup_menu(-name=>'beg_day',
                 -values=>$param_info{beg_day}{values},
                 -default=>$param_info{beg_day}{default_value});
      $param_info{beg_hour}{param_label},
      popup_menu(-name=>'beg_hour',
                 -values=>$param_info{beg_hour}{values},
                 -default=>$param_info{beg_hour}{default_value}),
      $param_info{end_hour}{param_label},
      popup_menu(-name=>'end_hour',
                 -values=>$param_info{end_hour}{values},
                 -default=>$param_info{end_hour}{default_value});
   }
   print p(),
   $param_info{hostname}{param_label},
   textfield(-name=>'hostname',
             -size=>$param_info{hostname}{max_field_size}),
   radio_group(-name=>'host_mod',
               -values=>$param_info{host_mod}{values},
               -default=>$param_info{host_mod}{default_value}),
   p(),
   radio_group(-name=>'port_join',
               -values=>$param_info{port_join}{values},
               -default=>$param_info{port_join}{default_value}),
   $param_info{port_num}{param_label},
   textfield(-name=>'port_num',
             -size=>$param_info{port_num}{max_field_size}),
   radio_group(-name=>'port_mod',
               -values=>$param_info{port_mod}{values},
               -default=>$param_info{port_mod}{default_value}),
   p(),
   radio_group(-name=>'net_join',
               -values=>$param_info{net_join}{values},
               -default=>$param_info{net_join}{default_value}),
   $param_info{netname}{param_label},
   textfield(-name=>'netname',
             -size=>$param_info{netname}{max_field_size}),
   radio_group(-name=>'net_mod',
               -values=>$param_info{net_mod}{values},
               -default=>$param_info{net_mod}{default_value}),
   p(),
   radio_group(-name=>'gen_join',
               -values=>$param_info{gen_join}{values},
               -default=>$param_info{gen_join}{default_value}),
   $param_info{gen_pat}{param_label},
   textfield(-name=>'gen_pat',
             -size=>$param_info{gen_pat}{max_field_size}),
   p(),
   submit(-name=>'Action', -label=>'Search'),
   end_form;
}
#
# Subroutine to check the submitted parameters for validity.
#
sub check_parameters {
   $aborted = 0;
   my $p;
   if (! (defined(param('hostname')) or defined(param('netname')) or 
          defined(param('gen_pat')) or defined(param('port_num')))) {
      print h3("Please specify something for which to search:\n");
      $aborted++;
   }
   unless ($aborted) {
      foreach $p (@_) {
         my $errors_found = 0;
         next if ($p eq 'Action');
         my $pval = param($p);
         next if (length($pval) == 0);
         my $p2 = $pval;
#        print "Param: $p = $pval";
#        print ", Length = ", length($pval);
         $errors_found++ if (length($pval) > $param_info{$p}{max_field_size});
         unless ($errors_found) {
            if ($param_info{$p}{param_type} eq "string") {
               $_ = $pval;
               eval "tr/$param_info{$p}{validity_string}//d";
               my $cnt = length($_);
#              print ", String cnt = ", $cnt;
               $errors_found++ if ($cnt);
            } elsif ($param_info{$p}{param_type} eq "list") {
               $errors_found++ unless (grep { /$pval/ } @{ $param_info{$p}{values} });
#              print ", List" if ($errors_found);
            } elsif ($param_info{$p}{param_type} eq "number") {
               $errors_found++ if (($pval < $param_info{$p}{min_value}) or 
                                    ($pval > $param_info{$p}{max_value}));
            }
         }
#        print "\n";
         if ($errors_found) {
            print p(), b(i("Invalid value for: $param_info{$p}{param_label}."));
         }
#        Delete($p);
         $aborted += $errors_found;
      }
   }
#  print a({-href=>self_url}, 'Try again');
   &print_form() if ($aborted);;
}
#
$JSCRIPT=<<END;
// Open a window
function OpenWindow(page, win_name, horiz, vert) {
        var newwin = window.open(page, win_name,
            "width="+horiz+",height="+vert+",scrollbars=no,resizable=no,status=no");
        newwin.focus();
        if (newwin != null && newwin.opener == null) newwin.opener = self;
}
END
#
POSIX::setsid();
$group_pid = $$;
$SIG{HUP} = sub { kill(-TERM, $$) };
#
print header,
start_html(-title=>'Intrusion Detection pattern search',
           -author=>'RalphWD@nswc.navy.mil',
           -script=>$JSCRIPT,
           -bgcolor=>"#D2FFD2",
          );
if (!param) {
   &print_form();
} else {
   select STDOUT; $| = 1;              # make unbuffered
#
# Check the submitted parameters to insure that they meet sanity checks and
# are not deliberate attempts to sabotage this script.
#
   @changed_params = param();
   &check_parameters(@changed_params);
   $site = param('site') || $param_info{site}{default_value};
   $nslookup = param('nslookup') || $param_info{nslookup}{default_value};
   $beg_year = param('beg_year') || $param_info{beg_year}{default_value};
   $beg_month = param('beg_month') || $param_info{beg_month}{default_value};
   $beg_day = param('beg_day') || $param_info{beg_day}{default_value};
   $beg_hour = param('beg_hour') || $param_info{beg_hour}{default_value};
   $end_year = param('end_year') || $param_info{end_year}{default_value};
   $end_month = param('end_month') || $param_info{end_month}{default_value};
   $end_day = param('end_day') || $param_info{end_day}{default_value};
   $end_hour = param('end_hour') || $param_info{end_hour}{default_value};
   $hostname = param('hostname') || $param_info{hostname}{default_value};
   $host_mod = param('host_mod') || $param_info{host_mod}{default_value};
   $port_join = param('port_join') || $param_info{port_join}{default_value};
   $port_num = param('port_num') if (length(param('port_num')));
   $port_mod = param('port_mod') || $param_info{port_mod}{default_value};
   $net_join = param('net_join') || $param_info{net_join}{default_value};
   $netname = param('netname') || $param_info{netname}{default_value};
   $net_mod = param('net_mod') || $param_info{net_mod}{default_value};
   $gen_join = param('gen_join') || $param_info{gen_join}{default_value};
   $gen_pat = param('gen_pat') || $param_info{gen_pat}{default_value};
#
   $yr1 = $beg_year - 1900;
   $yr2 = $end_year - 1900;
   $beg_time = timelocal(0, 0, $beg_hour, $beg_day, $month_no{$beg_month}, $yr1);
   @beg_date = localtime($beg_time);
   $end_time = timelocal(0, 0, $end_hour, $end_day, $month_no{$end_month}, $yr2);
#  $end_time += 3600;
   @end_date = localtime($end_time);
#
# Construct the parameters that will be shipped to the pat_search.pl script.
#
   unless($aborted) {
      $site = param('site');
      $pattern = "";
      if ($hostname) {
         $pattern .= ($host_mod . " ")  if ($host_mod ne "either");
         $pattern .= "host " . $hostname . " ";
      }
      if (length($port_num)) {
         $pattern .= ($port_join . " ") if ($pattern);
         $pattern .= ($port_mod . " ") if ($port_mod ne "either");
         $pattern .= "port " . $port_num . " ";
      }
      if ($netname) {
         $pattern .= ($net_join . " ") if ($pattern);
         $pattern .= ($net_mod . " ")  if ($net_mod ne "either");
         $pattern .= "net " . $netname . " ";
      }
      if ($gen_pat) {
         $pattern .= ($gen_join . " ") if ($pattern);
         $pattern .= " " . $gen_pat . " ";
      }
      $lookup_string = param('nslookup');
      $nslookup = ($lookup_string eq 'Yes')?"":"-n";
      $bdate = strftime("%Y/%m/%d-%H:00:00", @beg_date);
      $edate = strftime("%Y/%m/%d-%H:00:00", @end_date);
      $kill_cmd = "/cgi-bin/kill_group.cgi?group_pid=${group_pid}";
      $perl_cmd = "$SHADOW_PATH/pat_search.pl";
      print 
      a({-name=>'kill',
         -href=>"$kill_cmd",
         -target=>'killer',
         -onClick=>"OpenWindow('', 'killer', '200','50')"},
          img({-align=>'left',-src=>'/images/abort.jpg',-border=>'0'})),
      a({-name=>'print', -href=>'javascript:window.print()'}, 
        img({-align=>'right',-src=>'/images/print.jpg',-border=>'0'})),
      h1("Your answers: "),
      p(" Sensor: $param_info{site}{labels}{$site} -- Host lookup: $lookup_string"),
      p(" Dates: $bdate - $edate ----- Pattern: $pattern");
      print STDOUT "\n<PRE>\n";
#
      $date1 = strftime("%Y%m%d%H", @beg_date);
      $date2 = strftime("%Y%m%d%H", @end_date);
      $params =  "$nslookup -l $site -b $date1 -e $date2 -p '$pattern'";
      $cmd = "${perl_cmd} ${params}";
      print "Search Command: $cmd\n\n";
      if ($pid = open(SEARCH, "-|")) {
         while (<SEARCH>) {
            print STDOUT $_;
         }
         close(SEARCH);
      } else {
         STDOUT->autoflush(1);
         exec($cmd);
         exit;
      }

      print STDOUT "\n</PRE>\n";
   }
}
print end_html;
