#!/usr/bin/perl
#
# tools.cgi         -  SHADOW Version 1.7
#                      Last changed 31 May 2001
#
#
# Written by Bill Ralph <RalphWD@nswc.navy.mil>
#
use CGI qw/:all /;
use CGI qw(small);
use CGI::Carp qw(fatalsToBrowser);
use POSIX qw(strftime);
use Time::Local;
#
do "/usr/local/etc/SHADOW.conf" || 
   die("Unable to open SHADOW configuration file /etc/SHADOW.conf.");
#
%month_no = (
   "Jan" => 0, "Feb" => 1, "Mar" => 2, "Apr" => 3, "May" => 4, "Jun" => 5,
   "Jul" => 6, "Aug" => 7, "Sep" => 8, "Oct" => 9, "Nov" => 10, "Dec" => 11);
#
@init_time = localtime(time);
$init_day = sprintf("%02i", $init_time[3]);
$init_mon = $init_time[4];
$init_mon_name = strftime("%b", @init_time);
$init_yr = 1900 + $init_time[5];
$init_site = "Sensor1";
$init_subdir = strftime("%b%d", @init_time);
#
$today = strftime("%Y%m%d", @init_time);
$tgt_day = $today;
$html_dir = "$SHADOW_REL_WEB_PAGES_ROOT/${init_site}/${init_subdir}";
$prefix = "$html_dir/${tgt_day}";
#
#
$JSCRIPT=<<END;
// Open a window
function OpenWindow(page, win_name, horiz, vert) {
        var newwin = window.open(page, win_name,
            "width="+horiz+",height="+vert+",scrollbars=yes,resizable=yes,status=yes");
        newwin.focus();
        if (newwin != null && newwin.opener == null) newwin.opener = self;
} 
END
print header,
   title('Intrusion Detection Tools'),
   start_html(-title=>'Intrusion Detection Tools', 
              -script=>$JSCRIPT,
              -author=>'RalphWD@nswc.navy.mil',
              -bgcolor=>'#0000A0',
              -link=>'#80FFFF',
              -vlink=>'#FFFF80', -alink=>'#FFFF80', -text=>'#000000',
             );
if (!param) {
      print start_form(-name=>'tools');
      print basefont({-size=>'2'});
      print font({-color=>'#FFFF80',-size=>1}, server_name());
      print_selectiontable();
      print_timetable($prefix);
      print_actiontable($html_dir, $tgt_day);
      end_form;
} else {
   select STDOUT; $| = 1;              # make unbuffered
#
   $tgt_site = param('site');
   $action = param('action');
   $tgt_day = param('day');
   $tgt_mon_name = param('month');
   $tgt_mon = $month_no{$tgt_mon_name};
   $tgt_yr = param('year') - 1900;
   @new_time = (0, 0, 0, $tgt_day, $tgt_mon, $tgt_yr, 0, 0, 0);
   $tgt_subdir = strftime("%b%d", @new_time);
   $tgt_day = strftime("%Y%m%d", @new_time);
   $html_dir = "$SHADOW_REL_WEB_PAGES_ROOT/${tgt_site}/${tgt_subdir}";
   $prefix = "$html_dir/${tgt_day}";
#
   print start_form(-name=>'tools');
   print basefont({-size=>'2'});
   print font({-color=>'#FFFF80',-size=>1}, server_name());
   print_selectiontable();
   print_timetable($prefix);
   print_actiontable($html_dir, $tgt_day);
#  print center(submit(-name=>'action', -value=>'Submit Changes')),
   end_form;
   print end_html();
   
}
#
sub print_selectiontable {
#
# Build the "Selection" table
#
%site_labels = (
                'Sensor1'     => 'Outside Router',
                'Sensor2'    => 'Outside Firewall',
                'Sensor3'    => 'Inside Firewall',
                );
   print 
      p(b(font({-color=>'#FFFF80'}, "Site: ")), 
      popup_menu(-name=>'site',
                  -values=>['Sensor1', 'Sensor2', 'Sensor3'],
                  -labels=>\%site_labels,
                  -default=>$init_site,
                  -onChange=>'javascript:document.tools.submit()'
                )
       ),
      p( b(font({-color=>'#FFFF80'}, "Year: ")),
      popup_menu(-name=>'year',
                 -values=>['1998','1999','2000','2001','2002'],
                 -default=>$init_yr,
                 -onChange=>'javascript:document.tools.submit()'
                 )
       ),
      p(b(font({-color=>'#FFFF80'}, "Month: ")),
      popup_menu(-name=>'month',
                 -values=>['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug',
                           'Sep', 'Oct','Nov','Dec'],
                 -default=>$init_mon_name,
                 -onChange=>'javascript:document.tools.submit()'
                 )
        ),
      p(b(font({-color=>'#FFFF80'}, "Day: ")), 
      popup_menu(-name=>'day',
                 -values=>['01','02','03','04','05','06','07','08','09','10',
                           '11','12', '13', '14','15','16','17','18','19',
                           '20','21','22', '23','24', '25','26','27','28',
                           '29','30','31'],
                 -default=>$init_day,
                 -onChange=>'javascript:document.tools.submit()'
                )
        );
}

sub print_actiontable {

#
# Build the "Action" table
#

   my $html_dir = $_[0];
   my $tgt_day = $_[1];
   print p(),
      table({-align=>'CENTER', -border=>'0', -bordercolor=>'#0000',
             -cellspacing=>'0', -cellpadding=>'1'},
            Tr(td({-align=>'CENTER',-valign=>'MIDDLE'},
                a({-name=>'statistics',
                   -href=>"${html_dir}/stats.${tgt_day}.html",
                   -target=>'shadow'},
                  img({-src=>'/images/statistics.png',-border=>'0'})
                 )
                 )
              ),
            Tr(td({-align=>'CENTER',-valign=>'MIDDLE'},
                a({-name=>'search',-href=>'/cgi-bin/search.cgi', 
                   -target=>'search',
                   -onClick=>"OpenWindow('/cgi-bin/search.cgi', 'search', '670', '700')"},
                  img({-src=>'/images/search.jpg',-border=>'0'})
                 )
                 )
              ),
            Tr(td({-align=>'CENTER',-valign=>'MIDDLE'},
                a({-name=>'lookup',-href=>'/cgi-bin/lookup.cgi', -target=>'lookup',
                   -onClick=>"OpenWindow('/cgi-bin/lookup.cgi', 'lookup','350','250')"},
                  img({-src=>'/images/lookup.jpg',-border=>'0'})
                 )
                 )
              ),
            Tr(td({-align=>'CENTER',-valign=>'MIDDLE'},
                a({-name=>'whois',-href=>'/cgi-bin/whois.cgi', -target=>'whois',
                   -onClick=>"OpenWindow('/cgi-bin/whois.cgi', 'whois', '350', '400')"},
                  img({-src=>'/images/whois.jpg',-border=>'0'})
                 )
                 )
              ),
            Tr(td({-align=>'CENTER',-valign=>'MIDDLE'},
                a({-name=>'compose',-href=>'/cgi-bin/compose_IR.cgi', 
                   -target=>'compose',
                   -onClick=>"OpenWindow('/cgi-bin/compose_IR.cgi','compose','620','675')"},
                  img({-src=>'/images/report.jpg',-border=>'0'})
                 )
                 )
              ),
            Tr(td({-align=>'CENTER',-valign=>'MIDDLE'},
                a({-name=>'NMAP',-href=>'/privileged/nmap.cgi', 
                   -target=>'nmap',
                   -onClick=>"OpenWindow('','nmap','520','330')"},
                  img({-src=>'/images/nmap.jpg',-border=>'0'})
                 )
                 )
              ),
      )
}
#
sub print_timetable {
#
#
# Build the Time of day table
#
   my $prefix = $_[0];
   print
      table({-align=>'CENTER', -border=>'5', -bordercolor=>'#0000',
             -cellspacing=>'1', -cellpadding=>'1'},
         Tr({-align=>'CENTER',-valign=>'MIDDLE'}, 
              a(b(font({-color=>'#FFFF80'}, "Hour")))),
         Tr(
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}00.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("00"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}01.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("01"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}02.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("02"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}03.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("03")))),
         Tr(
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}04.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("04"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}05.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("05"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}06.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("06"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}07.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("07")))),
         Tr(
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}08.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("08"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}09.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("09"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}10.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("10"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}11.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("11")))),
         Tr(
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}12.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("12"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}13.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("13"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}14.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("14"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}15.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("15")))),
         Tr(
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}16.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("16"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}17.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("17"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}18.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("18"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}19.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("19")))),
         Tr(
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}20.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("20"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}21.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("21"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}22.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("22"))),
            td({-align=>'CENTER',-valign=>'MIDDLE'},
               a({-target=>'shadow', -href=>"${prefix}23.html",
                  -onClick=>'javascript:document.tools.submit()'}, b("23")))));
}
