#! /usr/bin/perl
#
# print_stats.pl         - SHADOW Version 1.7
#                          Last changed 5 Jun 2001
#
#
#  Script to read a file dumped by statistics.pl containging a number of
#  arrays and hashes with statistics from one or more tcpdump files, and
#  print out those statistics.
#
#  Written by Bill Ralph <RalphWD@nswc.navy.mil>
#
#
do '/usr/local/etc/SHADOW.conf' or
   die("Unable to find SHADOW config file /usr/local/etc/SHADOW.conf");
#
require "$SHADOW_PATH/statistics.ph";
use File::Basename;
use Cwd;
#
# First calling parameter is raw Storable file to read. Second parameter is 
# statistics output file.
#
$file_name = basename($ARGV[0]);
$data_dir = dirname($ARGV[0]);
$outfile = $ARGV[1];
#
# Fetch previous stored data if it exists
#
$data_file = "${data_dir}/${file_name}";
&fetch_state($data_file);
#
# Print out the results.
#
&printem($outfile, $data_file);
#
# End of print_stats.pl
#
