# Systemwide variables needed by the SHADOW package
#
# gmt.ph           - SHADOW release 1.7
#                    Last changed 23 Jul 2001
#
# Author: Olav Kolbu <olav.kolbu@usit.uio.no>
# Editor: Bill Ralph <wralph@nswc.navy.mil>
#
# This code is hereby released into the public domain. It is released
# "as-is". All warranties disclaimed, implied or otherwise.
#

use POSIX qw(strftime);
use Time::Local;

# We need various timestamps all over the place. Set these variables
# according to your preferences. If you have sensors crossing time zones,
# you might need GMT(UTC).
#
@T = gmtime(time);
$TZ = "GMT";
#
#@T = localtime(time);
#$TZ = "LOC";

# The location of the scripts to be run on the sensor machine.
#
*PROGLOC  = $SENSOR_PATH;

# The full path to the 'tcpdump' program

$LOGPROG  = "/usr/sbin/tcpdump";	# RH Linux if using tcpdump RPM
#$LOGPROG  = "/usr/local/sbin/tcpdump";	# Another common location
$PROGPAR  = "-i eth0";			# Parameter necessary for Linux

# The full path to the 'gzip' program

$GZIPPROG = "/bin/gzip";

# The log directory

$LOGDIR   = "/LOG";

# The name of the current logfile
#
$tmp = strftime("%Y%m%d%H", @T);
$LOGFILE = "tcp.$tmp.gz";
$TCPLOG   = "$LOGDIR/$LOGFILE";

