#!/bin/sh
#
# sensor_init.sh -   SHADOW release 1.7
#                    Last changed 23 Jul 2001
#
# chkconfig: 345 98 11
# description: SHADOW sensor scripts
#
# This shell script should be inserted into the /etc/rc.d/init.d directory of
# Redhat Linux. The chkconfig line above will  make the necessary symbolic
# links if you type "chkconfig sensor add." 
#
# Your mileage will vary if not using RedHat.
#
# description: Starts and stops the tcpdump process.

SENSOR_PATH=/usr/local/SHADOW/sensor
SENSOR_PARAMETER=std_eth0

# Source function library.
. /etc/rc.d/init.d/functions

# Source networking configuration.
. /etc/sysconfig/network

# See how we were called.

case "$1" in
  start|restart)
        echo -n "(Re-)Starting SHADOW sensor: "
        perl $SENSOR_PATH/sensor_driver.pl $SENSOR_PARAMETER > /dev/null 2>&1
        echo
        ;;
  stop)
        echo -n "Shutting down SHADOW sensor: "
        perl $SENSOR_PATH/stop_logger.pl $SENSOR_PARAMETER > /dev/null 2>&1
        echo ""
        ;;
  status)
        status tcpdump
        ;;
  *)
        echo "Usage: sensor {start|stop|restart|status}"
        exit 1
esac
