#!/usr/bin/perl
#
# start_logger.pl -  SHADOW release 1.7
#                    Last changed 23 Jul 2001
#
# startup-wrapper for the tcpdump used in the SHADOW tool.
#
# Author: Olav Kolbu <olav.kolbu@usit.uio.no>
# Modifier: Bill Ralph <wralph@nswc.navy.mil>
#
# This code is hereby released into the public domain. It is released
# "as-is". All warranties disclaimed, implied or otherwise.
# 

# These are the external variables we need. This must be in a suitable
# directory.
#
$SENSOR_PATH = "/usr/local/SHADOW/sensor";
unshift(@INC, $SENSOR_PATH);
#
# Added a calling parameter to specify the "variables" header file with
# needed parameter definitions. This easily allows different paths, values,
# and filters for particular situations. It should also allow multiple
# tcpdumps to run on a single machine.
# 
if ($ARGV[0] eq "ALL")
{
   chdir($SENSOR_PATH);
   @instances = <*.ph>;
} else {
   @instances = @ARGV;
}
foreach $instance (@instances)
{
   ($which, $rest) = split(/\./, $instance);
   die ("No such file: ${which}.ph") if ( ! -e "$SENSOR_PATH/${which}.ph");
   require "${which}.ph";
#
# The PID file containing the session ID of the last known 'tcpdump' started
# by the SHADOW sensor scripts.
#
   $LOGPID  = "$LOGDIR/$which.pid";
#
# The name of the filter file to have 'tcpdump' apply as it saves packets
#
   $FILTER = "$SENSOR_PATH/$which.filter";
#
# Current date goes into a file for later use
#
#
   $date = strftime("%Y%m%d%H $TZ", @T);
   open(DATE, ">$LOGDIR/sensor.date");
   print DATE $date;
   close(DATE);
#
#
# Prepare the parameters to pass to the tcpdump program.
#
   $param =  "$PROGPAR -w - -F $FILTER";
   $param .= " 2>>$LOGDIR/tcpdump.err| $GZIPPROG > $TCPLOG 2>/dev/null";

#
# Create the file and its link
#
   chdir($LOGDIR);
#
# If the output file already exists, we could have another process running
# and actively writing to the file. The safest thing to do is to abort the
# current start process and ask for intelligent human intervention.
#
#  die("Log file $TCPLOG already exists, aborting.") if ( -e $TCPLOG);
   unlink($TCPLOG) if ( -e $TCPLOG);
   open(OUT, ">$TCPLOG") or die("Unable to create $TCPLOG");
   close(OUT);

# Fire up the actual program. 
#
#
   if ($pid = fork) {
#
# Parent code
#
# Wait a couple of seconds for the child to get started.
#
# Set our session ID number to the pid of our parent.
# Saves the session ID in the LOGPID file.
#
      $sess_id = $pid;
      sleep 4;

#
#  Parent is done, make the child an orphan.
#
      next;

   } else {
#
# Child code.
#
      $pid = POSIX::getpid();
      $sess_id = POSIX::setsid();
      unlink $LOGPID;
      `echo "$sess_id" > $LOGPID`;
      exec("$LOGPROG $param &");
   }
}
exit 0;
