#!/usr/bin/perl
#
# stop_logger.pl -   SHADOW release 1.7
#                    Last changed 23 Jul 2001
#
# shutdown-wrapper for the tcpdump used in the SHADOW tool.
#
# Author: Olav Kolbu <olav.kolbu@usit.uio.no>
# Modifier: Bill Ralph <wralph@nswc.navy.mil>
#
# This code is hereby released into the public domain. It is released
# "as-is". All warranties disclaimed, implied or otherwise.
# 

# These are the external variables we need
#
$SENSOR_PATH = "/usr/local/SHADOW/sensor";
unshift(@INC, $SENSOR_PATH);
#
# Added a calling parameter to specify the "variables" header file with
# needed parameter definitions. This easily allows different paths, values,
# and filters for particular situations. It should also allow multiple
# tcpdumps to run on a single machine.
#
if ($ARGV[0] eq "ALL") 
{
   chdir($SENSOR_PATH);
   @instances = <*.ph>;
} else {
   @instances = @ARGV;
}
foreach $instance (@instances)
{
   ($which, $rest) = split(/\./, $instance);
   die ("No such file: ${which}.ph") if ( ! -e "$SENSOR_PATH/${which}.ph");
   require "${which}.ph";
#  
# The PID file containing the session ID of the last known 'tcpdump' started
# by the SHADOW sensor scripts.
# 
   $LOGPID  = "$LOGDIR/$which.pid";
#
# The name of the filter file to have 'tcpdump' apply as it saves packets
#
   $FILTER = "$SENSOR_PATH/$which.filter";
#

   if ( -f $LOGPID )
   {
#
# Fetch list of processes running with the saved session ID. Identify the
# pid of the tcpdump process running in that session, and signal it to end.
# The command: /bin/ps --sid $sess_id --noheader --format pid,cmd
# produces a listing of all processes running with session ID of $sess_id. 
# It works on RH Linux Version 6.2
#
# You may have to modifiy it for other systems.
#
      $sess_id = `cat $LOGPID`;
      $sess_id =~ s/\s+$//;           # Remove trailing whitspace
      @lines = `/bin/ps --sid $sess_id --noheader --format pid,cmd`;

#
      @dmp_line = grep /$LOGPROG/, @lines;
      if (scalar(@dmp_line) == 0) {
         print "$0: session $sess_id not running, aborting.\n";
         unlink $LOGPID;
         next;
      }
      $dmp_line[0] =~ s/^\s+//;               # Remove leading whitespace.
      ($pid, $cmd) = split(/\s+/,$dmp_line[0],2);
#------------------------------------------------------------------------
# For Solaris, change the preceding line to:
#     Courtesy of:      R. Brockway             Sr. Systems/Network Admin
#                       APK Net, Inc.           CCNA,CCDA,SCSA,SCNA
#
#     ($crap, $uid, $pid, $ppid, $rest) = split(/\s+/,$dmp_line[0],5);
#
# For OpenBSD 2.6, change the line to:
#     (courtesy of Lenny Zeltser [lenny@zeltser.com]
#
#     $pid = (split(/\s+/, $dmp_line[0]))[1];
#------------------------------------------------------------------------
      if ( ! $sess_id )
      {
        print "$0: Pid file '$LOGPID' bad or empty, aborting\n";
        unlink $LOGPID;
        next;
      }
      elsif ( kill (0, int($pid)) )
      {
        kill (15, int($pid));    
        sleep(2); # Give the program some time to finish
        if ( kill (0, int($pid)) )
        {
          print "$0: Unable to kill $LOGPROG, aborting\n";
          next;
        }
      }
      else
      {
        print "$0: PID: $pid was not running\n";
        next;
      }
      unlink $LOGPID;
   }
   else
   {

# Here we could have tried to locate the pid using 'ps' but
# we might zap a vital tcpdump run by some BOFH so we abstain.

     print "$0: NO pid file '$LOGPID', exiting\n";
     next; 
   }
}
exit 0;
