#  Variables needed by the analyzer scripts. Tailor this file
#  to define the paths for different sensor sites.
#
# Site.ph            - SHADOW Version 1.7
#                      Last changed 9 Jul 2001
#
use POSIX qw(strftime);
use Time::Local;
#
# The '$SITE" name is a name used to identify a sensor subdirectory. This name
# will be used to create subdirectories under the analyzer "/LOG" directory 
# and the home page of the web pages that SHADOW creates to display the data.
#
$SITE="Site1";
#
# Include a list of IP network addresses that are considered "inside" your site.
# (Not currently used in SHADOW-1.7)
#
@SITE_IP=("172.16.31", "192.168");
#
# Put here the name of the machine on which the SHADOW sensor software is
# located. The analyzer fetches the raw data from the sensor.
#
$SENSOR="sensor01.goodguys.com";
#
# Put the name of the machine which runs Apache to serve up your SHADOW
# generated web pages.
#
$WEB_SERVER="www.goodguys.com";
#
# Change the following line to reflect the directory on your sensor in which
# the raw sensor data is stored.
#
$SENSOR_DIR="/LOG";
#
# The following line reflects the directory on your analyzer machine
# into which the raw sensor data is fetched. The variable $SHADOW_RAW_DATA_PATH
# is defined in /usr/local/etc/SHADOW.conf.
#
$ANALYZER_DIR="$SHADOW_RAW_DATA_PATH/$SITE";
#
# The following line reflects the directory on your analyzer machine where
# SHADOW will create the web pages which hold the filtered data. The variable
# $SHADOW_WEB_PAGES_PATH is defined in /usr/local/etc/SHADOW.conf.
# 
$OUTPUT_WEB_DIR="$SHADOW_WEB_PAGES_PATH/$SITE";
#
# The following variable reflects the relative path from the DocumentRoot 
# variable defined in the Apache configuration files to the actual html files.
# The variable $SHADOW_REL_WEB_PAGES_ROOT is defined in 
# /usr/local/etc/SHADOW.conf.
#
$URL_OUTPUT_DIR="$SHADOW_REL_WEB_PAGES_ROOT/$SITE";
#
# The following line reflects where the filters for the site $SITE are 
# stored. The variable $SHADOW_FILTER_PATH is defined in 
# /usr/local/etc/SHADOW.conf.
#
$FILTER_DIR="$SHADOW_FILTER_PATH/$SITE";
#
# The SCAN_THRESHOLD is the number of different IPs that a "foreign" machine
# can contact before SHADOW lists that foreign machine as a possible scanner.
# Change it to reflect your preference.
#
$SCAN_THRESHHOLD = "7";
#
# Set the following variable to the number of days you want to keep the
# raw data files on your sensor's disks before the cleanup.pl script removes
# them. It depends on the sizes of your files, the amount of sensor disk space,
# and your taste.
#
$CLEAN_DATE = 2;
