#! /usr/bin/perl
#
# statistics.pl             - SHADOW Version 1.7
#                             Last changed 1 Jun 2001
#
#
#  Script to read a raw tcpdump hourly file, look at the packets,
#  and produce some statistics about the traffic seen in that file.
#  Optionally uses Compress::Zlib Perl module to directly read gzipped files.
#
#  Written by Bill Ralph <RalphWD@nswc.navy.mil>
#
do "/usr/local/etc/SHADOW.conf" ||
   die("Unable to load SHADOW configuration file: /usr/local/etc/SHADOW.conf.");
#
require "$SHADOW_PATH/statistics.ph";
#
# First calling parameter is raw gzipped file to read.
# Second is name of file into which to put the statistics text.
#
$rawfile = shift;
die("No gzipped tcpdump file specified, aborting.") if (! -e $rawfile);
$outfile = shift;
#
init_state();
#
# Read the Raw file and collect the statistics.
#
&read_rawfile($rawfile);
#
# Print the results.
#
&printem($outfile, $rawfile) if ($outfile);
#
#  End of statistics.pl
