#ifndef _AMAP_H

/* AMAP - application mapper Copyright (c) 2003 DJ.Rev.Moon and vanHauser
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.    
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *    
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define PROGRAM   "amap"
#define VERSION   "v2.5"
#define AUTHOR    "DJ.RevMoon and vanHauser"	// HEY, IT'S "DJ", NOT Dr.!!
						// And yes, you can get my latest
						// MP3 mix. 
#define EMAIL     "amap-dev@thc.org"
#define RESOURCE  "www.thc.org"

#define TIMEOUT_T 		5	// seconds to wait for response
#define MAX_PROTO_LEN		64	// max string length of protocol
#define BUFSIZE			4096	// standard buffer size
#define APP_FINGERPRINT_FILE	"appdefs"	// default filename
#define RESP_EXT		".resp"	// default extension
#define TRIG_EXT		".trig"	// default extension
#define RPC_EXT			".rpc"	// default extension

#define MAX_RETRIES	3	// connect() retries
#define MAX_TASKS	256	// maximum parrallel tasks
#define TASKS		32	// 16 is a nice number ;-)

/* Trigger types */
#define	TRIG_UNK	0
#define TRIG_STR	1
#define TRIG_HEX	2
#define TRIG_RPC	3

/* Search types */
#define SUB_STR		1
#define START_STR	2
#define NLSTART_STR	3
#define RPC_STR		4

/* Scan modes */
#define SCAN_PLAIN	1
#define SCAN_SSL	2
#define SCAN_RPC	3

//-----------------------------------------

// where are my appdefs files? all entries must end with a slash!
char *searchpath[14] = { "./", "/etc/", "/usr/etc/", "/usr/local/etc/",
  "/opt/etc/", "/usr/local/amap/", "/opt/amap/",
  "/usr/local/lib/", "/usr/local/lib/amap/",
  "/usr/lib/amap/", "/usr/local/bin/",
  "/usr/local/probe2/bin/", "/usr/local/probe2/etc/",
  NULL
};

//-----------------------------------------

typedef struct {
  char *appl_id;
  struct ll_appl_id *next;
} ll_appl_id;

typedef struct {
  char ip_prot;
  unsigned short int port;
  ll_appl_id *appl_ids;
  unsigned char *unknown_response;
  int unknown_response_length;
  int ssl;
  int rpc;
  int skip;
  struct ll_ports *next;
} ll_ports;

typedef struct {
  char *target;
  ll_ports *ports;
  struct ll_targets *next;
} ll_targets;

typedef struct {
  char *prot;
  char ip_prot;
  char *trigger_string;
  int trigger_length;
  int trigger_type;
  int dangerous;
  struct ll_trig *next;
} ll_triggers;

typedef struct {
  char *response_string;
  unsigned int response_length;
  int search_type;
  int counter;
  struct ll_response *next;
} ll_response;

typedef struct {
  char *prot;
  ll_response *response;
  struct ll_resp *next;
} ll_resp;

typedef struct {
  int active;			/* Is this socket active or not */
  int s;			/* The socket */
  SSL *ssl_sock;		/* The SSL socket descriptor */
  char ip_ad[16];		/* the IP address for this socket */
  unsigned short int port;	/* the port to connect to */
  char prot;			/* TCP, UDP or both */
  int ssl_enabled;		/* this socket uses ssl! */
  time_t timer;			/* time() when socket was created */
  char response[BUFSIZE];	/* the response received */
  char *orig_response;		/* same as above, but will not be manipulated */
  int response_length;		/* the length of the response received (could contain null bytes) */
  ll_triggers *trigger_ptr;
  ll_ports *port_ptr;
  ll_targets *target_ptr;
} sock_block;

#define _AMAP_H
#endif
