/*
 *			Address to Network Conversion Utility
 *				  by Paul Balyoz
 *
 *	Input:
 *		Full IP Address
 *		Network Mask
 *	Output:
 *		Zero-filled Network Address
 *	Algorithm:
 *		Do a Binary-And of the netmask on the address,
 *		and print the result to stdout.
 *	Diagnostics:
 *		If wrong number of args: "ERROR" to stdout, info to stderr.
 *		If unparsable args: "ERROR" to stdout, info to stderr.
 *		Exit value 0 if success, anything else indicates failure.
 */

#include <stdio.h>
#include <string.h>

char prog[BUFSIZ];

main (argc,argv)
int argc;
char *argv[];
{
	char *octetptr;
	unsigned long ip=0, mask=0, net=0;

	if (argc != 3) {
		printf ("ERROR\n");
		fprintf (stderr,"usage: %s ipaddress netmask\n", argv[0]);
		exit (1);
	}

/* parse first argument */

	octetptr = strtok (argv[1], ".");
	if (octetptr == NULL) {
		printf ("ERROR\n");
		fprintf (stderr,"usage:  %s ipaddress netmask\n", argv[0]);
		fprintf (stderr,"\terror on first arg.\n");
		exit (1);
	}
	ip = ip * 256 + atoi (octetptr);

	octetptr = strtok (NULL, ".");
	if (octetptr == NULL) {
		printf ("ERROR\n");
		fprintf (stderr,"usage:  %s ipaddress netmask\n", argv[0]);
		fprintf (stderr,"\terror on first arg.\n");
		exit (1);
	}
	ip = ip * 256 + atoi (octetptr);

	octetptr = strtok (NULL, ".");
	if (octetptr == NULL) {
		printf ("ERROR\n");
		fprintf (stderr,"usage:  %s ipaddress netmask\n", argv[0]);
		fprintf (stderr,"\terror on first arg.\n");
		exit (1);
	}
	ip = ip * 256 + atoi (octetptr);

	octetptr = strtok (NULL, ".");
	if (octetptr == NULL) {
		printf ("ERROR\n");
		fprintf (stderr,"usage:  %s ipaddress netmask\n", argv[0]);
		fprintf (stderr,"\terror on first arg.\n");
		exit (1);
	}
	ip = ip * 256 + atoi (octetptr);

/* parse second argument */

	octetptr = strtok (argv[2], ".");
	if (octetptr == NULL) {
		printf ("ERROR\n");
		fprintf (stderr,"usage:  %s ipaddress netmask\n", argv[0]);
		fprintf (stderr,"\terror on second arg.\n");
		exit (1);
	}
	mask = mask * 256 + atoi (octetptr);

	octetptr = strtok (NULL, ".");
	if (octetptr == NULL) {
		printf ("ERROR\n");
		fprintf (stderr,"usage:  %s ipaddress netmask\n", argv[0]);
		fprintf (stderr,"\terror on second arg.\n");
		exit (1);
	}
	mask = mask * 256 + atoi (octetptr);

	octetptr = strtok (NULL, ".");
	if (octetptr == NULL) {
		printf ("ERROR\n");
		fprintf (stderr,"usage:  %s ipaddress netmask\n", argv[0]);
		fprintf (stderr,"\terror on second arg.\n");
		exit (1);
	}
	mask = mask * 256 + atoi (octetptr);

	octetptr = strtok (NULL, ".");
	if (octetptr == NULL) {
		printf ("ERROR\n");
		fprintf (stderr,"usage:  %s ipaddress netmask\n", argv[0]);
		fprintf (stderr,"\terror on second arg.\n");
		exit (1);
	}
	mask = mask * 256 + atoi (octetptr);

/* Now apply the mask to strip out non-network bits */

	net = ip & mask;

/* Finally write out the answer */

	printf ("%d.%d.%d.%d\n",	(net>>24)&0xFF,
					(net>>16)&0xFF,
					(net>> 8)&0xFF,
					(net    )&0xFF );

/* game over, man, game over! */

	exit (0);
}
