#	axfroutany.awk	- DIG zone transfer output parsing script
#
#	Extract all records from DIG zone transfer, and output them
#	one per line.  Output format is: record type, data.
#       Each line consists of a domain name, the record type in uppercase,
#       and the contents of that record as space-delimited fields.
#
#	If no answer records are found, we exit with status 1,
#	otherwise exit with status 0.

BEGIN {
	numrecs = 0;
	status = "none";
	insoa = 0;
	inwks = 0;
}

NF==0	{ next; }

/^;/	{ next; }


# For all good input lines...

{
	numrecs++;

# If we aren't previously inside an SOA record currently, parse this record;
# if it's not an SOA, then just print it; else remember origin and mailaddr.

	if (insoa == 0 && inwks == 0) {
		if ($3 == "SOA") {
			domain = $1;
			origin = $4;
			mailaddr = $5;
			valuelist = "";
			insoa = 1;

		} else if ($3 == "WKS") {
			domain = $1;
			ip = $4;
			protocol = $5;
			wkslist = "";
			inwks = 1;

		} else {
			printf "%s ", $1;
			for (i=3; i<NF; i++)
				printf "%s ", $i;
			print $NF;
		}

# If we are inside an SOA record, add the number on this line to our list
# of values.  If this line also has an end-parenthesis then it's the last
# line of the SOA record so we need to print everything.

	} else if (insoa == 1) {
		valuelist = valuelist " " $1;
		if ($2 == ")") {
			insoa = 0;
			print domain " SOA " origin " " mailaddr valuelist;
		}

# If we are inside an WKS record, add the entries on this line to our list
# of wks's.  If this line also has an end-parenthesis then it's the last
# line of the WKS record so we need to print everything.

	} else if (inwks == 1) {
		for (i=1; i<NF; i++)
			wkslist = wkslist " " $i;
		if ($NF != ")") {
			wkslist = wkslist " " $NF;
		} else {
			inwks = 0;
			print domain " WKS " ip " " protocol wkslist;
		}
	}
}

# After all records have been dealt with, if none were printed then return
# an error status; otherwise return a normal exit status.

END {
	if (numrecs < 1)
		exit 1;
	exit 0;
}
