#	Base Domain determination code
#	"cse.nau.edu." -> "nau.edu."
#	If not exactly one field on input, we exit immediately with status 1.
#	Multiple lines get processed separately, output to separate lines.
#	If some problem occurs, exit 1.  No problems we exit 0.

BEGIN {
	retval = 0;
}

{
# If not exactly one field on each line, error.
	if (NF != 1) {
		retval = 1;
		exit retval;
	}

# if root domain, we can't determine what domain that's in, so error.
	if ($0 == ".") {
		retval = 1;
		exit retval;
	}

# break the domain name into pieces and print the answer.
# of course, if we don't see any dots at all, that's an error.
	n = split ($0, f, ".");
	if (n < 2) {
		retval = 1;
		exit retval;
	}

	for (i=2; i<n-1; i++)
		printf ("%s.", f[i]);
	if (n > 2)
		printf ("%s", f[n-1]);
	printf (".\n");
}

END {
	exit retval;
}
