# ipsort.awk

BEGIN {
	lines = 0;
}

{
	num = split ($1, f, ".");
	if (num != 4) {
		print "ipsort.awk: error: first col must be IP addr on all recs!" | "cat 1>&2";
		exit;
	}
	lines++;
	IP[lines] = $1;
	line[lines] = $0;
}

# Do the sort and output.

END {
	for (i=1; i<=lines; i++) {
#print "trying i=" i " IP=" IP[i];
		split (IP[i], fi, ".");
		ia = fi[1]+0; ib = fi[2]+0; ic = fi[3]+0; id = fi[4]+0;
		for (j=i+1; j<=lines; j++) {
#print "trying j=" j " IP=" IP[j];
			split (IP[j], fj, ".");
			ja = fj[1]+0; jb = fj[2]+0; jc = fj[3]+0; jd = fj[4]+0;
			if (ja<ia || ja==ia&&(jb<ib || jb==ib&&(jc<ic || jc==ic&&(jd<id)))) {
#print "   j is less than i so swapping";
				tempIP = IP[i];
				templine = line[i];
				IP[i] = IP[j];
				line[i] = line[j];
				IP[j] = tempIP;
				line[j] = templine;
				split (IP[i], fi, ".");
				ia = fi[1]+0; ib = fi[2]+0; ic = fi[3]+0; id = fi[4]+0;
			}
		}
		print line[i];
	}
}
