#
# domsort.awk
#
#	input:		rainbow.cse.nau.edu.
#	output:		!edu!nau!cse!rainbow rainbow.cse.nau.edu.
#
# The output from here can be sorted with "sort", then run thru "sed"
# to strip off the first token, leaving behind the original good strings
# in domain-name-sorted order.  Exclamation marks are used instead of
# periods because it is a character that comes very early in the
# ascii character set, right after space, and before all other letters,
# numbers, and punctuation.  The problem was that domain names containing
# a hyphen "-" at the critical point were sorting incorrectly.
#
# If you can sort the following two groups of data, you've probably
# solved the problem:
#
#	Input Data 1:
#		smg.ucc.nAu.edu
#		ucc-sunnet.nAu.edu
#		systems1.ucc.nAu.edu
#
#	Input Data 2:
#		a1.ucc.nau.edu.
#		ucc-sunnet.nau.edu.
#		ucc.nau.edu.
#
# The exclamation mark must NOT sort BEFORE the space character,
# so that any given domain comes before it's subdomains.
#

{
	num = split ($1, f, ".");
	revdom=f[1];
	for (i=2; i<=num; i++)
		revdom = f[i] "!" revdom;
	print revdom " " $0;
}
