#	Forward to Inverse Address Conversion
#	"134.114.64.1" -> "1.64.114.134.in-addr.arpa."
#	If not exactly one field on input, we exit right then with status 1.
#	Multiple lines get processed separately, output to separate lines.

BEGIN {
	retval = 0;
}

{
	if (NF != 1) {
		retval = 1;
		exit retval;
	}

	n = split ($0, f, ".");
	for (i=n; i>=1; i--)
		if (f[i] != "")
			printf ("%s.",f[i]);
	printf ("in-addr.arpa.\n");
}

END {
	exit retval;
}
