#
# subdom.awk - parse AXFR records from DIG, look only at the NS records,
#             and print only the sub-domain names.
# NOTE: We know that input is axfr output, one record per line.
#

# NS and SOA records: print the first field because it's the subdomain name.

$2=="NS" || $2=="SOA" {
	print $1 " subdomain";
	next;
}

# All other records: print the sub-domain name portion of the first field.

{
	len = split ($1, f, ".");
	for (i=2; i<len; i++)
		printf ("%s.", f[i]);
	printf ("%s\n", f[len]);
}
