#
# subzone.awk - parse AXFR records from DIG, look only at the NS records,
#     		and print only the sub-zone names.  We get the current zone
#		from the SOA record, which must come before any NS records
#		that we are studying, or the NS records are ignored.
#
#		Output usually has multiple copies of each zone, since one
#		is printed for each NS record found.
#

BEGIN {
	zonename = "------------------------------------------";  # illegal
}

# SOA records: just remember the zone name

$2 == "SOA" {
	zonename = $1;
	next;
}

# NS records: if it is a subzone, print its name.

$2 == "NS" {
	# ALERT: Should be case-insensitive comparison here, but its not!
	if (length($1) > length(zonename) && \
substr($1,length($1)-length(zonename)+1,length(zonename)) == zonename) {
		print $1;
	}
}
