/*	exscan v0.4
	By PolarRoot (pi9@hotmail.com)
	
	Thanks:		darknite (darknite@kurir.net)
			  for his great article in the Fall 1998: "2600"
*/

// Request Variables
char HTTPREQ[19]  ="HEAD / HTTP/1.0";
char FINGERREQ[2] ="";
// Global Variables
int s;
struct hostent *host;
struct sockaddr_in sock;
#define MAX_LIST	65000
unsigned int pnum = 0;
unsigned int plist[MAX_LIST];
char hostname[1024];
// QueSO Variables
char QUESO_STRING[2][64];
int QUESO_PORT = 80;		// Default QueSO Port: 80
char QUESO_HOST[255];
unsigned int OPEN_PORT = 80;

#include "main.h"

int argport (int port, int argc, char **argv) {
	int i;

	if (pnum==0) return 1;
	for (i=0; i<pnum; i++)
		if (plist[i]==port) return 1;
	return 0;
}

int isnum (char *string) {
	int i;
	for (i=0; i<strlen(string); i++) {
		if (isdigit(string[i])!=0) continue;
		return 1;
	}
	return 0;
}

int check_commandline (int argc, char **argv) {
	int i;
	int j;

	// Test for too few arguments
	if (argc < 2) return 1;

	// Command-Line Parser
	for (i=1; i<argc; i++) {
		if (argv[i][0]=='-') continue;
		if (isnum(argv[i])==0) {
			plist[pnum]=atoi(argv[i]);
			pnum++;
			continue;
		}
		strcpy(hostname,argv[i]);
	}
	// Send command line to processor
	if (processcmd(argc, argv)==1) return 1;
	// Print All Arguments Processed
#ifdef DEBUG_MODE
	printf("Number of Ports: %i\n", pnum);
	for (i=0; i<pnum; i++)
		printf("Port: %i\n", plist[i]);
	printf("Hostname: %s\n", hostname);
	printf("OPT_LIST_SERVICES = %i\n", OPT_LIST_SERVICES);
	printf("OPT_DISABLE_QUESO = %i\n", OPT_DISABLE_QUESO);
	printf("OPT_VERBOSE_MODE  = %i\n", OPT_VERBOSE_MODE);
	printf("OPT_PRINT_VERSION = %i\n", OPT_PRINT_VERSION);
#endif
	// The command line must be ok!
	return 0;
}

void clear_screen () {
	printf("\033[2J");		// Clear the entire screen
	printf("\033[0;0f\n");		// Move cursor to the top-left
}

void main (int argc, char **argv) {
	setup();
// If changes are made to this section,
// mirror them below in the output to file section.
	printf("exscan - v0.4 - By PolarRoot [pi9@hotmail.com] [http://exscan.netpedia.net]\n");
	printf("        QueSO - Remote OS Identification - By Savage\n");
	printf("        QueSO code has been modified and integrated with permission.\n");
	if (check_commandline(argc, argv)) {
		printf("\nUsage:\n");
		printf("\t%s [options] <hostname> [port]\n", argv[0]);
		printf("\t[options]  - command line options (see list below)\n");
		printf("\t<hostname> - name of target computer (IP or name); required\n");
		printf("\t[port]     - port number(s) to scan; space-delimited list\n\n");
		printf("Options:\n");
		printf("\t-f <file>	- send output to <file> file\n");
		printf("\t-h or -?	- show on-screen help (this screen)\n");
		printf("\t-l		- only list services which would be scanned\n");
		printf("\t-o		- only perform QueSO - do not port scan\n");
		printf("\t-q		- disable QueSO remote OS identification\n");
		printf("\t-v		- verbose mode\n");
		printf("\t-V		- print version information\n\n");
		printf("Examples:\n");
		printf("\t%s 127.0.0.1\n", argv[0]);
		printf("\t%s www.rootshell.com 80\n", argv[0]);
		printf("\t%s www.l0pht.com 23 80 110\n\n", argv[0]);
		exit(0);
	}

	if (OPT_OUTPUT_FILE==1) {
		printf("\nOutput Will Be Directed To The File: %s\n", OUTPUT_FILE);
		hOUTPUT_FILE=fopen(OUTPUT_FILE, "a");
		fprintf(hOUTPUT_FILE, "exscan - v0.4 - By PolarRoot [pi9@hotmail.com] [http://exscan.netpedia.net]\n");
		fprintf(hOUTPUT_FILE, "        QueSO - Remote OS Identification - By Savage\n");
		fprintf(hOUTPUT_FILE, "        QueSO code has been modified and integrated with permission.\n");
		fprintf(hOUTPUT_FILE, "Output Will Be Directed To The File: %s\n", OUTPUT_FILE);
	}
	else hOUTPUT_FILE=stdout;

	if (OPT_PRINT_VERSION==1) {
		fprintf(hOUTPUT_FILE, "\n");
		exit(0);
	}

	if (OPT_LIST_SERVICES!=1) {
		host=gethostbyname(hostname);
		if (!host) exit(fprintf(hOUTPUT_FILE, "Error looking up hostname.\n"));
	sock.sin_family = AF_INET;
	sock.sin_addr.s_addr=*(long *)(host->h_addr);
	// Old, crappy code!
	//printf("Scanning Host: %s [%i.%i.%i.%i]\n\n", hostname, host->h_addr[0], host->h_addr[1], host->h_addr[2], host->h_addr[3]);
	fprintf(hOUTPUT_FILE, "Scanning Host: %s [%s]\n\n", hostname, inet_ntoa(sock.sin_addr));
	}     //OPT_LIST_SERVICES

	if (OPT_QUESO_ONLY!=1) {
		fprintf(hOUTPUT_FILE, "\n");

		// Scan for port   7 - echo
		if (argport(7, argc, argv)) ScanPort(7, "Echo");
		// Scan for port   9 - discard
		if (argport(9, argc, argv)) ScanPort(9, "Discard");
		// Scan for port  13 - daytime
		if (argport(13, argc, argv)) ScanPort(13, "Daytime");
		// Scan for port  17 - quote of the day
		if (argport(17, argc, argv)) ScanPort(17, "Quote of the Day");
		// Scan for port  19 - chargen
		if (argport(19, argc, argv)) ScanPort(19, "Character Generator");
		// Scan/data for port  21 - ftp
		if (argport(21, argc, argv)) ScanPortData(21, "File Transfer Protocol");
		// Scan/data for port  23 - telnet
		if (argport(23, argc, argv)) ScanPortData(23, "Telnet");
		// Scan/data for port  25 - smtp
		if (argport(25, argc, argv)) ScanPortData(25, "Simple Mail Transfer Protocol");
		// Scan for port  37 - time
		if (argport(37, argc, argv)) ScanPort(37, "Time");
		// Scan for port  53 - domain name server
		if (argport(53, argc, argv)) ScanPort(53, "Domain Name Server");
		// Scan/data for port  69 - trivial ftp
		if (argport(69, argc, argv)) ScanPortData(69, "Trivial File Transfer Protocol");
		// Scan for port  70 - gopher
		if (argport(70, argc, argv)) ScanPort(70, "Gopher");
		// Scan/query for port  79 - finger
		if (argport(79, argc, argv)) ScanPortQuery(79, "Finger", FINGERREQ);
		// Scan/query for port  80 - http
		if (argport(80, argc, argv)) ScanPortQuery(80, "Hypertext Transfer Protocol", HTTPREQ);
		// Scan/data for port 109 - pop2
		if (argport(109, argc, argv)) ScanPortData(109, "Post Office Protocol 2");
		// Scan/data for port 110 - pop3
		if (argport(110, argc, argv)) ScanPortData(110, "Post Office Protocol 3");
		// Scan for port 111 - sunrpc
		if (argport(111, argc, argv)) ScanPort(111, "SunRPC");
		// Scan for port 113 - authentication
		if (argport(113, argc, argv)) ScanPort(113, "Authentication");
		// Scan/data for port 119 - nntp
		if (argport(119, argc, argv)) ScanPortData(119, "Network News Transfer Protocol");
		// Scan for port 137 - netbios
		if (argport(137, argc, argv)) ScanPort(137, "NetBIOS Name Service");
		// Scan for port 138 - netbios
		if (argport(138, argc, argv)) ScanPort(138, "NetBIOS Datagram Service");
		// Scan for port 139 - netbios
		if (argport(139, argc, argv)) ScanPort(139, "NetBIOS Session Service");
		// Scan/data for port 143 - imap2
		if (argport(143, argc, argv)) ScanPortData(143, "Interim Mail Access Protocol 2");
		// Scan for port 201 - appletalk
		if (argport(201, argc, argv)) ScanPort(201, "AppleTalk Routing Maintenance");
		// Scan for port 202 - appletalk
		if (argport(202, argc, argv)) ScanPort(202, "AppleTalk Name Binding");
		// Scan for port 203 - appletalk
		if (argport(203, argc, argv)) ScanPort(203, "AppleTalk Unused");
		// Scan for port 204 - appletalk
		if (argport(204, argc, argv)) ScanPort(204, "AppleTalk Echo");
		// Scan for port 205 - appletalk
		if (argport(205, argc, argv)) ScanPort(205, "AppleTalk Unused");
		// Scan for port 206 - appletalk
		if (argport(206, argc, argv)) ScanPort(206, "AppleTalk Zone Information");
		// Scan for port 207 - appletalk
		if (argport(207, argc, argv)) ScanPort(207, "AppleTalk Unused");
		// Scan for port 208 - appletalk
		if (argport(208, argc, argv)) ScanPort(208, "AppleTalk Unused");
		// Scan/data for port 220 - imap3
		if (argport(220, argc, argv)) ScanPortData(220, "Interactive Mail Access Protocol 3");
		// Scan for port 512 - exec
		if (argport(512, argc, argv)) ScanPort(512, "exec");
		// Scan for port 513 - login
		if (argport(513, argc, argv)) ScanPort(513, "login");
		// Scan for port 514 - cmd
		if (argport(514, argc, argv)) ScanPort(514, "cmd");
		// Scan for port 515 - printer
		if (argport(515, argc, argv)) ScanPort(515, "printer");
		// Scan for port 517 - talk
		if (argport(517, argc, argv)) ScanPort(517, "talk");
		// Scan for port 635 - mount
		if (argport(635, argc, argv)) ScanPort(635, "NFS Mount");
	}

	// Remote OS Identification
	if (OPT_DISABLE_QUESO!=1) {
		fprintf(hOUTPUT_FILE, "\n\n");
		if (socket(AF_INET, SOCK_RAW, IPPROTO_RAW)<0) {
			fprintf(hOUTPUT_FILE, "QueSO Disabled, Due To Inability To Open RAW Sockets.\nYou must be ROOT to use QueSO and RAW Sockets.\n");
			OPT_DISABLE_QUESO=1;
		}
		else {
			strcpy(QUESO_HOST, hostname);
			strcat(QUESO_HOST, "\0");
			QUESO_PORT=OPEN_PORT;
			if(!qmain()) fprintf(hOUTPUT_FILE, "QueSO Remote OS Identification Failed!\n");
		}
	}

	fprintf(hOUTPUT_FILE, "\n\nScan Completed Successfully.\n");
	if (hOUTPUT_FILE != stdout)
		fprintf(hOUTPUT_FILE, "\n\n\t\t\t\t----------\n\n");
	fclose(hOUTPUT_FILE);
	exit(0);
}


