/*	The following code which has been modified and integrated 
	for use with exscan, was originally found in QueSO.
	This code has been modified and integrated with permission 
	from the author, savage (savage@apostols.org).
*/


/***************************************************************
 *
 * Proyecto:	QueSO ( Que Sistema Operativo ?? )      
 * Autor:       Jordi Murgo <savage@apostols.org>
 * Descripcion:	Determina el tipo de Sistema Operativo de una
 *              maquina concreta a partir del comportamiento 
 *              de su pila TCP/IP ante paquetes TCP 'raros'.
 *              Ver el codigo para mas informacion.
 * Licencia:	GNU GPL 
 *
 ***************************************************************
 * Agradecimientos a ToXyN, b0fh y a los colegas del canal #hack
 *		   especialmente a syn por la traduccion del doc
 ***************************************************************
 * CVS: $Id: queso.c,v 1.20 1998/09/22 20:35:43 savage Exp $
 ***************************************************************/

#include "main.h"
#include "qconfig.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <string.h>
#include <unistd.h>

extern char *optarg;
extern int optind, opterr, optopt;

#include "qtcpip.h"

static char *id = "$Id: queso.c,v 1.20 1998/09/22 20:35:43 savage Exp $";

#define ACK_HACK  1000
#define RANDOM_ACK (ACK_HACK+666)
#define MAXPKT 6

int MAXTIMER = 3;
int VECES = 1;
int Zzz = 100;
int DEFPORT = 80;
char *DEVICE=NULL, DEVBUFF[255];

/*----- CFG_FILE_NAME moved to Makefile -----*/
static char CFGFILE[255] = DFLT_CONFIG_FILE;

/*------------- Prototiping -----------------*/
void debugtcp (unsigned long, tcprec);
int checkos (struct sockaddr_in, short);

/*------------- Print TCP HDR ---------------*/
void
debugtcp (unsigned long myseq, tcprec tcp)
{
  fprintf (stderr, "%d->%d S:%1d A:%s%lX W:%04X U:%X F: ",
	   ntohs (tcp.sport), ntohs (tcp.dport),
	   (tcp.seqnum?1:0),
	   tcp.acknum?"+":" ",
	   (tcp.acknum?(unsigned long) ntohl (tcp.acknum)-myseq:0),
	   ntohs (tcp.window), ntohs (tcp.urgentptr));

  if (tcp.flags & URG)
    fprintf (stderr, "URG ");
  if (tcp.flags & SYN)
    fprintf (stderr, "SYN ");
  if (tcp.flags & RST)
    fprintf (stderr, "RST ");
  if (tcp.flags & FIN)
    fprintf (stderr, "FIN ");
  if (tcp.flags & ACK)
    fprintf (stderr, "ACK ");
  if (tcp.flags & PSH)
    fprintf (stderr, "PSH ");
  if (tcp.flags & XXX)
    fprintf (stderr, "XXX ");
  if (tcp.flags & YYY)
    fprintf (stderr, "YYY ");
  fprintf (stderr, "\n");
}

typedef struct
{
  unsigned short set;
  unsigned long seq;
  unsigned long ack;
  unsigned short urg;
  unsigned short win;
  unsigned short flag;
}
OSRES;

#define SILENT	0

int
check_os (struct sockaddr_in from, struct sockaddr_in dest, short dport)
{
  spoofrec spoof;
  tcprec tcp;
  unsigned short start, s;
  int n;
  long timeout;
  FILE *f;
  char line[1024];
  unsigned long myseq;


  OSRES r[MAXPKT + 1];
  for (n = 0; n <= MAXPKT; n++)
    {
      r[n].set = 0;
    }

  srand (time (NULL) & 0x0000ffff);
  start = s = (rand () % 26000) + 4000;
  spoof.seq = myseq = rand ();
  spoof.ack = 0;
  spoof.from = from;
  spoof.dest = dest;
  spoof.dport = dport;


  /*-- PKT 0 --*/
  spoof.sport = s++;
  sendtcp (&spoof, SYN, VECES);
  usleep (Zzz);

  /*-- PKT 1 --*/
  spoof.sport = s++;
  sendtcp (&spoof, SYN | ACK, VECES);
  usleep (Zzz);

  /*-- PKT 2 --*/
  spoof.sport = s++;
  sendtcp (&spoof, FIN, VECES);
  usleep (Zzz);

  /*-- PKT 3 --*/
  spoof.sport = s++;
  sendtcp (&spoof, FIN | ACK, VECES);
  usleep (Zzz);
  
  /*-- PKT 4 --*/
  spoof.sport = s++;
  sendtcp (&spoof, SYN | FIN, VECES);
  usleep (Zzz);

  /*-- PKT 5 --*/
  spoof.sport = s++;
  sendtcp (&spoof, PSH, VECES);
  usleep (Zzz);

  /*-- PKT 6 --*/
  spoof.sport = s++;
  sendtcp (&spoof, SYN | XXX | YYY, VECES);
  usleep (Zzz);

  timeout = time (NULL) + MAXTIMER;


  while ((timeout > time (NULL)))
    {
      if (gettcp (&spoof, &tcp))
	{
	  if (ntohs (tcp.sport) == dport)
	    {
	      n = ntohs (tcp.dport) - start;
	      if (n < 0 || n > MAXPKT)
		continue;	/* ignore invalid pkts */
	      if (r[n].set == 1)
		continue;	/* ignore duppes */


	      r[n].seq = tcp.seqnum ? 1 : 0;
	      r[n].ack = tcp.acknum ? (ntohl(tcp.acknum)-myseq+ACK_HACK) : 0;
	      if(r[n].ack > RANDOM_ACK)
		r[n].ack = RANDOM_ACK;
	      r[n].win = ntohs (tcp.window);
	      r[n].flag = tcp.flags;
	      r[n].set = 1;
	      r[n].urg = tcp.urgentptr ? 1 : 0;
	    }
	}
      else
	usleep (Zzz);
    }

  /*---------- CHECK RESULT -----------*/
  if ((f = fopen (CFGFILE, "r")))
    {
      char osname[256];		/* should be smaller than line[], 256 should suffice */
      unsigned short flag1 = 0, found = 0, linez = 0;
      unsigned short pn = 0, ps = 0, pa = 0, pw = 0, pf = 0, pu = 0;
      char *p;

      while (fgets (line, sizeof (osname) - 1, f))
	{
	  if (line[0] == '\n')
	    {
	      if (flag1 && found == linez)
		{
		  fprintf (hOUTPUT_FILE, "%s:%d\t%s", inet_ntoa (dest.sin_addr), dport, osname);
		  fclose (f);
		  if (osname[1] == '-')
		    return 0;	/* Not accurate response */
		  else
		    return 1;
		}
	    }

	  if (line[0] == '*')
	    {
	      strcpy (osname, line);
	      flag1 = 1;
	      found = 0, linez = 0;
	      continue;
	    }

	  /*------ PARSE LINE ---*/
	  linez++;
	  p = strtok (line, " ");
	  if (p && isdigit (*p))
	    pn = atoi (p);
	  else
	    {
	      linez = 0;
	      flag1 = 0;
	      found = 0;
	      continue;
	    }
	  
	  /*-- seq --*/
	  p = strtok (NULL, " ");
	  if (p)
	    ps = atoi (p);

	  /*-- ack --*/
	  p = strtok (NULL, " ");
	  if (p) 
	    {
	      if( *p == 'R' )
		pa = RANDOM_ACK;
	      else if( *p == '+' )
		pa = atoi (p)+ACK_HACK; /*-- extended ACK field --*/
	      else 
		pa = atoi (p);
	    }
	  
	  /*-- win --*/
	  p = strtok (NULL, " ");
	  if (p)
	    pw = 0xffff & strtol (p, NULL, 16);

	  /*-- flags --*/
	  p = strtok (NULL, " \n");
	  if (p)
	    {
	      pf = 0;
	      if (strchr (p, 'S'))
		pf |= SYN;
	      if (strchr (p, 'R'))
		pf |= RST;
	      if (strchr (p, 'A'))
		pf |= ACK;
	      if (strchr (p, 'F'))
		pf |= FIN;
	      if (strchr (p, 'P'))
		pf |= PSH;
	      if (strchr (p, 'X'))
		pf |= XXX;
	      if (strchr (p, 'Y'))
		pf |= YYY;
	      if (strchr (p, 'U'))
		pu = 1;
	      else
		pu = 0;
	    }


	  if (!r[pn].set)
	    {
	      if (pf)
		{
		  found = 0;
		  flag1 = 0;
		  continue;
		}
	      found++;
	      continue;
	    }

	  if ( 
	      ( pa>=ACK_HACK?(pa==r[pn].ack):pa==(r[pn].ack>0) ) &&
	      ps == r[pn].seq &&
	      ((pw == r[pn].win)
	       || (pw == 1 && r[pn].win)
	       || (!pw && !r[pn].win)
	       ) &&
	      pf == r[pn].flag &&
	      pu == r[pn].urg )
	    {
	      found++;
	      continue;
	    }
	  else
	    {
	      found = 0;
	      flag1 = 0;
	      continue;
	    }
	}

      fseek (f, 0L, SEEK_END);
      fclose (f);

	f = fopen (CFGFILE, "a");

      if (!f)
	{
	  fprintf (stderr, "Can't open RW %s\n", CFGFILE);
	  return 0;
	}
      fseek (f, 0L, SEEK_END);

	fprintf (hOUTPUT_FILE, "%s:%d\t*- Unknown OS, pleez update %s\n", inet_ntoa (dest.sin_addr), dport, CFGFILE);

      fprintf (f, "\n");
      fclose (f);
      
      return 0;
    }

  fprintf (stderr, "Can't open RO %s \n", CFGFILE);
  return -1;
}


/* -------------------------------------------------------- *
 * The main function 
 * -------------------------------------------------------- */
int
qmain ()
{
  struct sockaddr_in dest, from;
  unsigned short port;
  char *s, *p;
  int c;
  int accuracy;
  int limit = 0;
  int bits = 32;		/* single host */
  unsigned long firsthost, lasthost, netmask, host;
  
  /*
   * Unbuffer stdout and stderr
   */
  setvbuf (stderr, NULL, _IONBF, 0);
  setvbuf (stdout, NULL, _IONBF, 0);

  /*-- Init addr --*/
  from.sin_addr.s_addr = dest.sin_addr.s_addr = 0;

  /*
   * Chek Argumentz
   */
	DEFPORT = QUESO_PORT;

  /*-- Init raw sockets, we need r00t here --*/
  init_tcpip ();
  
  /*-- drops down to original user privileges --*/
  if (!geteuid ())
    setuid (getuid ());

  /*-- Hostname or IP --*/
  //for(; argv[optind]; optind++) {
    s = QUESO_HOST;
    limit = 0;

    
    /*-- NetMask --*/
    if ((p = strchr (s, '/')) != 0)
      {
	*p = 0;
	bits = atoi (++p);
	if (bits < 0)
	  {
	    bits *= -1;
	    limit = -1;
	  }
	else
	  {
	    if (strchr (p, '-'))
	      limit = 1;
	  }
      }
    else
      {
	p = s;
	bits = 32;
      }

    /*-- Port --*/
	port = DEFPORT;
    
    if (resolve_host (s, &dest) < 0) {
    	fprintf(stderr, "QueSO:  Unable to resolve host.\n");
    	exit (EXIT_FAILURE);
    }
    

    if (!from.sin_addr.s_addr)
      from.sin_addr = getlocalip (dest.sin_addr.s_addr);
    
    if (!from.sin_addr.s_addr)
      {
	fprintf (stderr, "QueSO:  Unable to Determine Local IP.\n");
	exit (EXIT_FAILURE);
      }
    
    host = ntohl (dest.sin_addr.s_addr);
    netmask = ~(0xFFFFFFFFL >> bits);
    /*-- WARNING: 32bit arquitectures have problems when bits==32 --*/
    firsthost = (host & netmask) + 1;
    lasthost = (host | ~(netmask)) - 1;
    
    if (limit < 0)
      lasthost = host;
    else if (limit > 0)
      firsthost = host;
    
    if (bits < 31) 
      {
	/*-- 0 to 30 bits --*/
	for (host = firsthost; host <= lasthost; host++)
	  {
	    dest.sin_addr.s_addr = htonl (host);
	    accuracy = check_os (from, dest, port);
	  }
      }
    else
      {
	/*-- 31 and 32 bits, ignore mask and check only the host --*/
	accuracy = check_os (from, dest, port);
      }
  //}
  
  return (1);  // EXIT_SUCCESSFUL != 0
}
