#ifndef FORGERS_H__
#define FORGERS_H__

typedef struct test*(*parser_func_t)(char *, struct test *);
typedef char*(*filter_func_t)(struct test*, int);
typedef int(*sender_func_t)(struct test*,int , int );
typedef char*(*display_func_t)(struct test*, int);
typedef void(*receiver_func_t)(struct test*, u_char*);
typedef void(*router_err_func_t)(struct test*, u_char*, int, int,int);
typedef char*(*local_filter_func_t)(struct test*);

struct forgers {
	int protocol;	     /* protocol the forger is in charge of */
	char * asc_protocol; /* protocol name in ASCII		    */
	filter_func_t  	filter;
	local_filter_func_t local_filter;
	sender_func_t 	sender;
	receiver_func_t receiver;
	parser_func_t   parser;
	display_func_t  display;
	router_err_func_t router_err;
	int translate;
	struct forgers * next;
	};
	
struct forgers * forger_get(char *);
void init_forgers();
#endif
