/* filterrules
 * Copyright (C) 1999 Herve Schauer Consultants and Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: master.c,v 1.20 1999/09/21 15:34:43 renaud Exp $
 *
 * Author : Renaud Deraison <Renaud.Deraison@hsc.fr>
 *
 */
#include <includes.h>
#include <libnet.h>
#include "utils.h"
#include "tests.h"
#include "master_pcap.h"
#include "matrix.h"
#include "forgers.h"
#include "ttls.h"
/*
 * Global variables
 */
 
/*
 * Remote == 1 <=> no slave
 * Remote == 0 <=> master and slave are on each side of the router
 */
int Remote = 0;

/*
 * Soc : global socket with the slave
 */
int Soc = 0;

/*
 * RawSock : a raw socket
 */
int RawSoc = 0;

/*
 * Pcap : our packet capture (for the icmp unreach errors)
 */
pcap_t * Pcap;


/* 
 * Iface: the interface associated to our Pcap
 */
char * Iface;


/*
 * Policy to show
 */
int Policy = POL_AUTO;

/*
 * Routers
 */
struct in_addr * Routers;

/*
 * Symbolic name of the ICMP codes
 */

char *Icmp_codes[] = {"ICMP_UNREACH_NET", "ICMP_UNREACH_HOST",
		      "ICMP_UNREACH_PROTOCOL",
		      "ICMP_UNREACH_PORT",
		      "ICMP_UNREACH_NEEDFRAG",
		      "ICMP_UNREACH_SRCFAIL",
		      "ICMP_UNREACH_NET_UNKNOWN",
		      "ICMP_UNREACH_HOST_UNKNOWN",
		      "ICMP_UNREACH_ISOLATED",
		      "ICMP_UNREACH_NET_PROHIB",
		      "ICMP_UNREACH_HOST_PROHIB",
		      "ICMP_UNREACH_TOSNET",
		      "ICMP_UNREACH_TOSHOST",
		      "ICMP_UNREACH_FILTER_PROHIB",
		      "ICMP_UNREACH_PRECEDENCE",
		      "ICMP_UNREACH_PRECEDENCE_CUTOFF",NULL};
/*
 * init_network 
 *
 * 	hostname : name of the host to connect to
 *	port	 : port of the host to connect to (TCP)
 *
 *
 * This function establishes the connection with the slave,
 * and will report an error if any.
 *
 * Returns :
 *
 *  int : socket to the slave
 */
int init_network(hostname, port)
 char * hostname;
 int port;
{
 
 struct sockaddr_in soca;
 int soc;

 soca.sin_addr.s_addr = libnet_name_resolve(hostname, 1);
 if(!soca.sin_addr.s_addr)
 {
  printf("%s - host not found\n", hostname);
  exit(1);
 }
 
 if((soc = socket(AF_INET, SOCK_STREAM, 0))<0){
 	perror("socket ");
	exit(1);
	}
 soca.sin_port = htons(port);
 soca.sin_family = AF_INET;
 if((connect(soc, (struct sockaddr*)&soca, sizeof(struct sockaddr_in)))<0)
 {
  perror("connect ");
  exit(1);
 }
 return(soc);
}


#ifndef HAVE_INET_ATON
/*
 * Coming straight from Fyodor's Nmap
 */
int
inet_aton(cp, addr)
	register const char *cp;
	struct in_addr *addr;
{
	register unsigned int val;	/* changed from u_long --david */
	register int base, n;
	register char c;
	u_int parts[4];
	register u_int *pp = parts;

	c = *cp;
	for (;;) {
		/*
		 * Collect number up to ``.''.
		 * Values are specified as for C:
		 * 0x=hex, 0=octal, isdigit=decimal.
		 */
		if (!isdigit((int)c))
			return (0);
		val = 0; base = 10;
		if (c == '0') {
			c = *++cp;
			if (c == 'x' || c == 'X')
				base = 16, c = *++cp;
			else
				base = 8;
		}
		for (;;) {
			if (isascii((int)c) && isdigit((int)c)) {
				val = (val * base) + (c - '0');
				c = *++cp;
			} else if (base == 16 && isascii((int)c) && isxdigit((int)c)) {
				val = (val << 4) |
					(c + 10 - (islower((int)c) ? 'a' : 'A'));
				c = *++cp;
			} else
				break;
		}
		if (c == '.') {
			/*
			 * Internet format:
			 *	a.b.c.d
			 *	a.b.c	(with c treated as 16 bits)
			 *	a.b	(with b treated as 24 bits)
			 */
			if (pp >= parts + 3)
				return (0);
			*pp++ = val;
			c = *++cp;
		} else
			break;
	}
	/*
	 * Check for trailing characters.
	 */
	if (c != '\0' && (!isascii((int)c) || !isspace((int)c)))
		return (0);
	/*
	 * Concoct the address according to
	 * the number of parts specified.
	 */
	n = pp - parts + 1;
	switch (n) {

	case 0:
		return (0);		/* initial nondigit */

	case 1:				/* a -- 32 bits */
		break;

	case 2:				/* a.b -- 8.24 bits */
		if (val > 0xffffff)
			return (0);
		val |= parts[0] << 24;
		break;

	case 3:				/* a.b.c -- 8.8.16 bits */
		if (val > 0xffff)
			return (0);
		val |= (parts[0] << 24) | (parts[1] << 16);
		break;

	case 4:				/* a.b.c.d -- 8.8.8.8 bits */
		if (val > 0xff)
			return (0);
		val |= (parts[0] << 24) | (parts[1] << 16) | (parts[2] << 8);
		break;
	}
	if (addr)
		addr->s_addr = htonl(val);
	return (1);
}
#endif


void usage()
{
  printf("usage : master -f test_file [ -r ] [-H host[:port]] [-p deny|accept|all|auto]\n");
  exit(1);
}


int main(argc, argv)
	int argc;
	char ** argv;
{
  char * hostname = NULL;
  int port = 0;
  char * test_file = NULL;
  char i;
  char * iface = NULL;


  while((i=getopt(argc,argv,"f:H:p:i:rv"))!=-1)switch(i)
   {
    case 'v' : 
    	printf("fr_master, version %s\n", VERSION);
	printf("\tCopyright (C) 1999 Herve Schauer Consultants - http://www.hsc.fr\n");
	printf("\t               and Renaud Deraison <deraison@cvs.nessus.org>\n");
	exit(0);
	break;
    case 'f' :
    	if(!optarg)usage();
    	test_file = optarg;
	break;
    case 'H' :
    	{
	char * t;
	if(!optarg)usage();
	t = strchr(optarg, ':');
	if(t)t[0]=0;
	hostname = strdup(optarg);
	if(t)port = atoi(t+1);
	else port = 19123;
	}break;
    case 'p' :
    	if(!optarg)usage();
	else if(!strcmp(optarg, "accept"))Policy = POL_ACCEPT;
	else if(!strcmp(optarg, "deny"))Policy = POL_DENY;
	else if(!strcmp(optarg, "all"))Policy = POL_ALL;
	else if(!strcmp(optarg, "auto"))Policy = POL_AUTO;
	else usage();
	break;
     case 'i' :
     	if(!optarg)usage();
	else iface = strdup(optarg);
	break;
     case 'r' :
     	Remote = 1;
	break;	
   }
 
  if(!Remote)
  {
   if((!hostname)||(!test_file))usage();
   Soc = init_network(hostname,port);
  } else init_ttl_table();

  /*
   * We need a raw socket to send data to the target
   */
  RawSoc = open_raw_sock(IPPROTO_RAW);
  if(RawSoc < 0){
  	printf("Could not open a raw socket. Be root\n");
	exit(1);
	}
  free(hostname);
  
  init_forgers();
  
  
  /* init the packet capture, for ICMP replies */
  Pcap = init_pcap(iface);
  
  /*
   * Our main loop
   */
  tests_main(test_file);
  pcap_close(Pcap);
  return(0);
  
}
