/* filterrules
 * Copyright (C) 1999 Herve Schauer Consultants and Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: routers.c,v 1.5 1999/09/21 15:34:43 renaud Exp $
 *
 * Author : Renaud Deraison <Renaud.Deraison@hsc.fr>
 *
 */

#include <includes.h>


/*
 * Some packets will, in addition to being dropped, generate
 * an ICMP error message, which will be very useful to us, 
 * since it will allow us to determine which router
 * dropped the packet _and_ which error message the router
 * sent.
 *
 * However, keeping track of these messages may be a pain,
 * that's why we do a little trick :
 *
 * 	- the IPs of the router are stored in a 'router table',
 *	  and each IP is given an index
 *	- then, we store in the matrix the icmp error added
 *	  to the shifted value of the index of the router
 *	  that sent this value. We add 2 to the icmp_error code, 
 *	  so that we know that the lowest significants bits of the
 *	  item won't be the same for a passed or denied packet
 * 	  (0 or 1) and a rejected packet (whatever else).
 *
 * So : 
 * 
 * mat[y][x] = (router_index << 8) + (icmp_error_code+2)
 *
 *
 * This method may sound somewhat awkward and dirty, so if you have a 
 * better idea, let me know !
 */
struct in_addr * init_routers_table()
{
 struct in_addr * ret = malloc(255*(sizeof (struct in_addr)));
 bzero(ret, 253*(sizeof(struct in_addr)));
 return(ret);
}


/* 
 * add a router in the table and returns its
 * index. If the router was already in the table, then
 * don't add it twice, but just return its index
 */
int add_router(table, ip)
	struct in_addr * table;
	struct in_addr ip;
{
 int i = 0;
 for(i=0;((table[i].s_addr)&&(table[i].s_addr != ip.s_addr));i++);
 if(!table[i].s_addr)table[i].s_addr = ip.s_addr;
 return(i);
}
