/* filterrules
 * Copyright (C) 1999 Herve Schauer Consultants and Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: source_route.c,v 1.5 1999/09/21 15:34:43 renaud Exp $
 *
 * Author : Renaud Deraison <Renaud.Deraison@hsc.fr>
 *
 */
 
#include <includes.h>
#include <libnet.h>
#include "tests.h"
/*
 * Each protocol may be added an optional 'source route' option :
 * a list of routers to go through.
 *
 * These functions fill the test structure with the list of routers
 * to go through, and insert the source route option in the IP
 * packet.
 *
 * The insert_source_route() function goes around a little 
 * libnet bug.
 *
 */



/*
 * Put the routers we will go through in the appropriate
 * section of our 'test' structure
 *
 */
void source_route_parser(test, str)
	struct test * test;
	char *str;
{
 struct in_addr * ips = malloc(255*sizeof(long));
 int i = 0;
 char * d = str;
 struct in_addr ia;
 bzero(ips, 255*sizeof(long));
 test->source_route = (long)ips;
 while(d){
  char *t;
  
  t = d+1;
  d = strchr(t, ':');
  if(d)d[0]=0;
  inet_aton(t, &ia);
  ips[i++].s_addr=ia.s_addr;
  }
}


/*
 * Insert the source routing option in a IP packet.
 *
 * This function was _not_ tested, and is pure theory.
 * The libnet appears to have problems regarding ip options,
 * that's why we trick it
 */
void insert_source_route(test, buf)
	struct test * test;
	u_char * buf;
{
 long * ips = (long*)test->source_route;
 int i;
 int j;
 struct ipoption ipo;
 bzero(ipo.ipopt_list, MAX_IPOPTLEN);
 ipo.ipopt_list[0] = 0x83;	/* activate the source routing */
 i = 0;
 j = 3;
 while(ips[i])
 {
   memcpy((char*)&(ipo.ipopt_list[j]), (char*)&(ips[i]), sizeof(long));
   i++;
   j+=4;
 }
 ipo.ipopt_list[1] = j;
 ipo.ipopt_list[2] = 4;
 while(j%4)j++; /* libnet bug workaround -- wonderful, isn't it ? */
 if((insert_ipo(&ipo, j, buf))<0)printf("insert_ipo error ?!\n"); 
}
